/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.Constraint;
import com.github.stephengold.joltjni.ConstraintSettingsRef;
import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.StateRecorder;
import com.github.stephengold.joltjni.TwoBodyConstraint;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.enumerate.EConstraintType;
import com.github.stephengold.joltjni.readonly.ConstTwoBodyConstraint;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.template.Ref;
import java.nio.DoubleBuffer;

public final class TwoBodyConstraintRef
extends Ref
implements ConstTwoBodyConstraint {
    public TwoBodyConstraintRef() {
        long refVa = TwoBodyConstraintRef.createDefault();
        this.setVirtualAddress(refVa, () -> TwoBodyConstraintRef.free(refVa));
    }

    TwoBodyConstraintRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> TwoBodyConstraintRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public void notifyShapeChanged(int bodyId, Vec3Arg deltaCom) {
        long constraintVa = this.targetVa();
        float dx = deltaCom.getX();
        float dy = deltaCom.getY();
        float dz = deltaCom.getZ();
        Constraint.notifyShapeChanged(constraintVa, bodyId, dx, dy, dz);
    }

    @Override
    public Body getBody1() {
        long constraintVa = this.targetVa();
        long bodyVa = TwoBodyConstraint.getBody1(constraintVa);
        Body result = new Body(bodyVa);
        return result;
    }

    @Override
    public void getBody1PivotLocation(DoubleBuffer storeResult) {
        long constraintVa = this.targetVa();
        TwoBodyConstraint.getBody1PivotLocation(constraintVa, storeResult);
    }

    @Override
    public Body getBody2() {
        long constraintVa = this.targetVa();
        long bodyVa = TwoBodyConstraint.getBody2(constraintVa);
        Body result = new Body(bodyVa);
        return result;
    }

    @Override
    public void getBody2PivotLocation(DoubleBuffer storeResult) {
        long constraintVa = this.targetVa();
        TwoBodyConstraint.getBody2PivotLocation(constraintVa, storeResult);
    }

    @Override
    public Mat44 getConstraintToBody1Matrix() {
        long constraintVa = this.targetVa();
        long matrixVa = TwoBodyConstraint.getConstraintToBody1Matrix(constraintVa);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    @Override
    public Mat44 getConstraintToBody2Matrix() {
        long constraintVa = this.targetVa();
        long matrixVa = TwoBodyConstraint.getConstraintToBody2Matrix(constraintVa);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    @Override
    public int getConstraintPriority() {
        long constraintVa = this.targetVa();
        int result = Constraint.getConstraintPriority(constraintVa);
        return result;
    }

    @Override
    public ConstraintSettingsRef getConstraintSettings() {
        long constraintVa = this.targetVa();
        long settingsRefVa = Constraint.getConstraintSettings(constraintVa);
        ConstraintSettingsRef result = new ConstraintSettingsRef(settingsRefVa, true);
        return result;
    }

    @Override
    public boolean getEnabled() {
        long constraintVa = this.targetVa();
        boolean result = Constraint.getEnabled(constraintVa);
        return result;
    }

    @Override
    public int getNumPositionStepsOverride() {
        long constraintVa = this.targetVa();
        int result = Constraint.getNumPositionStepsOverride(constraintVa);
        return result;
    }

    @Override
    public int getNumVelocityStepsOverride() {
        long constraintVa = this.targetVa();
        int result = Constraint.getNumVelocityStepsOverride(constraintVa);
        return result;
    }

    @Override
    public EConstraintSubType getSubType() {
        long constraintVa = this.targetVa();
        int ordinal = Constraint.getSubType(constraintVa);
        EConstraintSubType result = EConstraintSubType.values()[ordinal];
        return result;
    }

    @Override
    public EConstraintType getType() {
        long constraintVa = this.targetVa();
        int ordinal = Constraint.getType(constraintVa);
        EConstraintType result = EConstraintType.values()[ordinal];
        return result;
    }

    @Override
    public boolean isActive() {
        long constraintVa = this.targetVa();
        boolean result = Constraint.isActive(constraintVa);
        return result;
    }

    @Override
    public void saveState(StateRecorder recorder) {
        long constraintVa = this.targetVa();
        long recorderVa = recorder.va();
        Constraint.saveState(constraintVa, recorderVa);
    }

    @Override
    public TwoBodyConstraint getPtr() {
        long constraintVa = this.targetVa();
        TwoBodyConstraint result = (TwoBodyConstraint)Constraint.newConstraint(constraintVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = TwoBodyConstraintRef.getPtr(refVa);
        return result;
    }

    @Override
    public TwoBodyConstraintRef toRef() {
        long refVa = this.va();
        long copyVa = TwoBodyConstraintRef.copy(refVa);
        TwoBodyConstraintRef result = new TwoBodyConstraintRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native long getPtr(long var0);
}

