/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.readonly.Vec4Arg;
import java.util.Objects;

public final class Vec4
implements Vec4Arg {
    private float w;
    private float x;
    private float y;
    private float z;

    public Vec4() {
        this.w = 0.0f;
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vec4(double x, double y, double z, double w) {
        this.w = (float)w;
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    public Vec4(float x, float y, float z, float w) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec4(float[] array) {
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
        this.w = array[3];
    }

    public Vec4(Vec3Arg vec, float w) {
        this.x = vec.getX();
        this.y = vec.getY();
        this.z = vec.getZ();
        this.w = w;
    }

    public Vec4(Vec4Arg vec) {
        this.w = vec.getW();
        this.x = vec.getX();
        this.y = vec.getY();
        this.z = vec.getZ();
    }

    public void set(float x, float y, float z, float w) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(float[] array) {
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
        this.w = array[3];
    }

    public void set(Vec4Arg source) {
        this.x = source.getX();
        this.y = source.getY();
        this.z = source.getZ();
        this.w = source.getW();
    }

    public void setW(float w) {
        this.w = w;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void splatW() {
        this.x = this.w;
        this.y = this.w;
        this.z = this.w;
    }

    public void splatX() {
        this.w = this.x;
        this.y = this.x;
        this.z = this.x;
    }

    public void splatY() {
        this.w = this.y;
        this.x = this.y;
        this.z = this.y;
    }

    public void splatZ() {
        this.w = this.z;
        this.x = this.z;
        this.y = this.z;
    }

    public static Vec4 sReplicate(float value) {
        Vec4 result = new Vec4(value, value, value, value);
        return result;
    }

    public static Vec4 sZero() {
        Vec4 result = new Vec4();
        return result;
    }

    @Override
    public float dot(Vec4Arg factor) {
        float result = this.w * factor.getW() + this.x * factor.getX() + this.y * factor.getY() + this.z * factor.getZ();
        return result;
    }

    @Override
    public float get(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException("index must be 0, 1, 2, or 3");
    }

    @Override
    public float getW() {
        return this.w;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    @Override
    public float[] toArray() {
        float[] result = new float[]{this.x, this.y, this.z, this.w};
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Vec4Arg otherVector = (Vec4Arg)other;
        if (Float.compare(this.x, otherVector.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.y, otherVector.getY()) != 0) {
            return false;
        }
        if (Float.compare(this.z, otherVector.getZ()) != 0) {
            return false;
        }
        return Float.compare(this.w, otherVector.getW()) == 0;
    }

    public int hashCode() {
        int result = Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.w));
        return result;
    }

    public String toString() {
        String result = "Vec4(" + this.x + " " + this.y + " " + this.z + " " + this.w + ")";
        return result;
    }
}

