/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.Constraint;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.VehicleAntiRollBar;
import com.github.stephengold.joltjni.VehicleCollisionTester;
import com.github.stephengold.joltjni.VehicleConstraintRef;
import com.github.stephengold.joltjni.VehicleConstraintSettings;
import com.github.stephengold.joltjni.VehicleController;
import com.github.stephengold.joltjni.VehicleStepListener;
import com.github.stephengold.joltjni.Wheel;
import com.github.stephengold.joltjni.readonly.ConstVehicleConstraint;
import com.github.stephengold.joltjni.readonly.ConstVehicleConstraintSettings;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class VehicleConstraint
extends Constraint
implements ConstVehicleConstraint {
    private final Body body;
    private VehicleCollisionTester tester;

    public VehicleConstraint(Body body, ConstVehicleConstraintSettings settings) {
        long settingsVa = settings.targetVa();
        assert (VehicleConstraintSettings.getController(settingsVa) != 0L) : "no controller";
        assert (settings.getNumWheels() > 0) : "no wheels";
        this.body = body;
        long bodyVa = body.va();
        long constraintVa = VehicleConstraint.createConstraint(bodyVa, settingsVa);
        this.setVirtualAddressAsCoOwner(constraintVa);
    }

    VehicleConstraint(long constraintVa) {
        this.setVirtualAddressAsCoOwner(constraintVa);
        long bodyVa = VehicleConstraint.getVehicleBody(constraintVa);
        this.body = new Body(bodyVa);
    }

    public VehicleController getController() {
        long constraintVa = this.va();
        long controllerVa = VehicleConstraint.getController(constraintVa);
        VehicleController result = VehicleController.newController(this, controllerVa);
        return result;
    }

    public VehicleStepListener getStepListener() {
        long constraintVa = this.va();
        long listenerVa = VehicleConstraint.getStepListener(constraintVa);
        VehicleStepListener result = new VehicleStepListener(this, listenerVa);
        return result;
    }

    public Body getVehicleBody() {
        return this.body;
    }

    public VehicleCollisionTester getVehicleCollisionTester() {
        assert (this.verifyTester());
        return this.tester;
    }

    public Wheel getWheel(int wheelIndex) {
        long constraintVa = this.va();
        long wheelVa = VehicleConstraint.getWheel(constraintVa, wheelIndex);
        int ordinal = Constraint.getControllerType(constraintVa);
        Wheel result = Wheel.newWheel(wheelVa, ordinal, this);
        return result;
    }

    public void overrideGravity(float ax, float ay, float az) {
        long constraintVa = this.va();
        VehicleConstraint.overrideGravity(constraintVa, ax, ay, az);
    }

    public void overrideGravity(Vec3Arg acceleration) {
        float ax = acceleration.getX();
        float ay = acceleration.getY();
        float az = acceleration.getZ();
        this.overrideGravity(ax, ay, az);
    }

    public void resetGravityOverride() {
        long constraintVa = this.va();
        VehicleConstraint.resetGravityOverride(constraintVa);
    }

    public void setMaxPitchRollAngle(float angle) {
        long constraintVa = this.va();
        VehicleConstraint.setMaxPitchRollAngle(constraintVa, angle);
    }

    public void setNumStepsBetweenCollisionTestActive(int numSteps) {
        long constraintVa = this.va();
        VehicleConstraint.setNumStepsBetweenCollisionTestActive(constraintVa, numSteps);
    }

    public void setNumStepsBetweenCollisionTestInactive(int numSteps) {
        long constraintVa = this.va();
        VehicleConstraint.setNumStepsBetweenCollisionTestInactive(constraintVa, numSteps);
    }

    public void setVehicleCollisionTester(VehicleCollisionTester tester) {
        this.tester = tester;
        long constraintVa = this.va();
        long testerVa = tester.va();
        VehicleConstraint.setVehicleCollisionTester(constraintVa, testerVa);
    }

    @Override
    public int countAntiRollBars() {
        long constraintVa = this.va();
        int result = VehicleConstraint.countAntiRollBars(constraintVa);
        return result;
    }

    @Override
    public int countWheels() {
        long constraintVa = this.va();
        int result = VehicleConstraint.countWheels(constraintVa);
        return result;
    }

    @Override
    public VehicleAntiRollBar getAntiRollBar(int barIndex) {
        long constraintVa = this.va();
        long barVa = VehicleConstraint.getAntiRollBar(constraintVa, barIndex);
        VehicleAntiRollBar result = new VehicleAntiRollBar(this, barVa);
        return result;
    }

    @Override
    public Vec3 getGravityOverride() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraint.getGravityOverride(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getLocalForward() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraint.getLocalForward(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getLocalUp() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraint.getLocalUp(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getMaxPitchRollAngle() {
        long constraintVa = this.va();
        float result = VehicleConstraint.getMaxPitchRollAngle(constraintVa);
        return result;
    }

    @Override
    public int getNumStepsBetweenCollisionTestActive() {
        long constraintVa = this.va();
        int result = VehicleConstraint.getNumStepsBetweenCollisionTestActive(constraintVa);
        return result;
    }

    @Override
    public int getNumStepsBetweenCollisionTestInactive() {
        long constraintVa = this.va();
        int result = VehicleConstraint.getNumStepsBetweenCollisionTestInactive(constraintVa);
        return result;
    }

    @Override
    public void getWheelLocalBasis(Wheel wheel, Vec3 storeForward, Vec3 storeUp, Vec3 storeRight) {
        long constraintVa = this.va();
        long wheelVa = wheel.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraint.getWheelLocalBasis(constraintVa, wheelVa, storeFloats);
        storeForward.set(storeFloats);
        storeUp.set(storeFloats, 3);
        storeRight.set(storeFloats, 6);
    }

    @Override
    public RMat44 getWheelWorldTransform(int wheelIndex, Vec3Arg right, Vec3Arg up) {
        long constraintVa = this.va();
        float rx = right.getX();
        float ry = right.getY();
        float rz = right.getZ();
        float ux = up.getX();
        float uy = up.getY();
        float uz = up.getZ();
        long matrixVa = VehicleConstraint.getWheelWorldTransform(constraintVa, wheelIndex, rx, ry, rz, ux, uy, uz);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public Vec3 getWorldUp() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraint.getWorldUp(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public boolean isGravityOverridden() {
        long constraintVa = this.va();
        boolean result = VehicleConstraint.isGravityOverridden(constraintVa);
        return result;
    }

    @Override
    public VehicleConstraintRef toRef() {
        long constraintVa = this.va();
        long refVa = VehicleConstraint.toRef(constraintVa);
        VehicleConstraintRef result = new VehicleConstraintRef(refVa, true);
        return result;
    }

    private boolean verifyTester() {
        long expectedVa = this.tester == null ? 0L : this.tester.targetVa();
        long constraintVa = this.va();
        long testerVa = VehicleConstraint.getVehicleCollisionTester(constraintVa);
        return testerVa == expectedVa;
    }

    static native int countAntiRollBars(long var0);

    static native int countWheels(long var0);

    private static native long createConstraint(long var0, long var2);

    static native long getAntiRollBar(long var0, int var2);

    static native long getController(long var0);

    static native void getGravityOverride(long var0, FloatBuffer var2);

    static native void getLocalForward(long var0, FloatBuffer var2);

    static native void getLocalUp(long var0, FloatBuffer var2);

    static native float getMaxPitchRollAngle(long var0);

    static native int getNumStepsBetweenCollisionTestActive(long var0);

    static native int getNumStepsBetweenCollisionTestInactive(long var0);

    private static native long getStepListener(long var0);

    private static native long getVehicleBody(long var0);

    private static native long getVehicleCollisionTester(long var0);

    private static native long getWheel(long var0, int var2);

    static native void getWheelLocalBasis(long var0, long var2, FloatBuffer var4);

    static native long getWheelWorldTransform(long var0, int var2, float var3, float var4, float var5, float var6, float var7, float var8);

    static native void getWorldUp(long var0, FloatBuffer var2);

    static native boolean isGravityOverridden(long var0);

    static native void overrideGravity(long var0, float var2, float var3, float var4);

    static native void resetGravityOverride(long var0);

    static native void setMaxPitchRollAngle(long var0, float var2);

    private static native void setNumStepsBetweenCollisionTestActive(long var0, int var2);

    private static native void setNumStepsBetweenCollisionTestInactive(long var0, int var2);

    private static native void setVehicleCollisionTester(long var0, long var2);

    private static native long toRef(long var0);
}

