/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Constraint;
import com.github.stephengold.joltjni.ConstraintSettingsRef;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.StateRecorder;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.VehicleAntiRollBar;
import com.github.stephengold.joltjni.VehicleConstraint;
import com.github.stephengold.joltjni.Wheel;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.enumerate.EConstraintType;
import com.github.stephengold.joltjni.readonly.ConstVehicleConstraint;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.template.Ref;
import java.nio.FloatBuffer;

public final class VehicleConstraintRef
extends Ref
implements ConstVehicleConstraint {
    public VehicleConstraintRef() {
        long refVa = VehicleConstraintRef.createDefault();
        this.setVirtualAddress(refVa, () -> VehicleConstraintRef.free(refVa));
    }

    VehicleConstraintRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> VehicleConstraintRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public void overrideGravity(float ax, float ay, float az) {
        long constraintVa = this.targetVa();
        VehicleConstraint.overrideGravity(constraintVa, ax, ay, az);
    }

    public void overrideGravity(Vec3Arg acceleration) {
        float ax = acceleration.getX();
        float ay = acceleration.getY();
        float az = acceleration.getZ();
        this.overrideGravity(ax, ay, az);
    }

    public void resetGravityOverride() {
        long constraintVa = this.targetVa();
        VehicleConstraint.resetGravityOverride(constraintVa);
    }

    @Override
    public int countAntiRollBars() {
        long constraintVa = this.targetVa();
        int result = VehicleConstraint.countAntiRollBars(constraintVa);
        return result;
    }

    @Override
    public int countWheels() {
        long constraintVa = this.targetVa();
        int result = VehicleConstraint.countWheels(constraintVa);
        return result;
    }

    @Override
    public VehicleAntiRollBar getAntiRollBar(int barIndex) {
        long constraintVa = this.targetVa();
        long barVa = VehicleConstraint.getAntiRollBar(constraintVa, barIndex);
        VehicleAntiRollBar result = new VehicleAntiRollBar(this, barVa);
        return result;
    }

    @Override
    public int getConstraintPriority() {
        long constraintVa = this.targetVa();
        int result = Constraint.getConstraintPriority(constraintVa);
        return result;
    }

    @Override
    public ConstraintSettingsRef getConstraintSettings() {
        long constraintVa = this.targetVa();
        long settingsRefVa = Constraint.getConstraintSettings(constraintVa);
        ConstraintSettingsRef result = new ConstraintSettingsRef(settingsRefVa, true);
        return result;
    }

    @Override
    public boolean getEnabled() {
        long constraintVa = this.targetVa();
        boolean result = Constraint.getEnabled(constraintVa);
        return result;
    }

    @Override
    public Vec3 getGravityOverride() {
        long constraintVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraint.getGravityOverride(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getLocalForward() {
        long constraintVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraint.getLocalForward(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getLocalUp() {
        long constraintVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraint.getLocalUp(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getMaxPitchRollAngle() {
        long constraintVa = this.targetVa();
        float result = VehicleConstraint.getMaxPitchRollAngle(constraintVa);
        return result;
    }

    @Override
    public int getNumPositionStepsOverride() {
        long constraintVa = this.targetVa();
        int result = Constraint.getNumPositionStepsOverride(constraintVa);
        return result;
    }

    @Override
    public int getNumStepsBetweenCollisionTestActive() {
        long constraintVa = this.targetVa();
        int result = VehicleConstraint.getNumStepsBetweenCollisionTestActive(constraintVa);
        return result;
    }

    @Override
    public int getNumStepsBetweenCollisionTestInactive() {
        long constraintVa = this.targetVa();
        int result = VehicleConstraint.getNumStepsBetweenCollisionTestInactive(constraintVa);
        return result;
    }

    @Override
    public int getNumVelocityStepsOverride() {
        long constraintVa = this.targetVa();
        int result = Constraint.getNumVelocityStepsOverride(constraintVa);
        return result;
    }

    @Override
    public EConstraintSubType getSubType() {
        long constraintVa = this.targetVa();
        int ordinal = Constraint.getSubType(constraintVa);
        EConstraintSubType result = EConstraintSubType.values()[ordinal];
        return result;
    }

    @Override
    public EConstraintType getType() {
        long constraintVa = this.targetVa();
        int ordinal = Constraint.getType(constraintVa);
        EConstraintType result = EConstraintType.values()[ordinal];
        return result;
    }

    @Override
    public void getWheelLocalBasis(Wheel wheel, Vec3 storeForward, Vec3 storeUp, Vec3 storeRight) {
        long constraintVa = this.targetVa();
        long wheelVa = wheel.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraint.getWheelLocalBasis(constraintVa, wheelVa, storeFloats);
        storeForward.set(storeFloats);
        storeUp.set(storeFloats, 3);
        storeRight.set(storeFloats, 6);
    }

    @Override
    public RMat44 getWheelWorldTransform(int wheelIndex, Vec3Arg right, Vec3Arg up) {
        long constraintVa = this.targetVa();
        float rx = right.getX();
        float ry = right.getY();
        float rz = right.getZ();
        float ux = up.getX();
        float uy = up.getY();
        float uz = up.getZ();
        long matrixVa = VehicleConstraint.getWheelWorldTransform(constraintVa, wheelIndex, rx, ry, rz, ux, uy, uz);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public Vec3 getWorldUp() {
        long constraintVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraint.getWorldUp(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public boolean isActive() {
        long constraintVa = this.targetVa();
        boolean result = Constraint.isActive(constraintVa);
        return result;
    }

    @Override
    public boolean isGravityOverridden() {
        long constraintVa = this.targetVa();
        boolean result = VehicleConstraint.isGravityOverridden(constraintVa);
        return result;
    }

    @Override
    public void saveState(StateRecorder recorder) {
        long constraintVa = this.targetVa();
        long recorderVa = recorder.va();
        Constraint.saveState(constraintVa, recorderVa);
    }

    @Override
    public VehicleConstraint getPtr() {
        long constraintVa = this.targetVa();
        VehicleConstraint result = new VehicleConstraint(constraintVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = VehicleConstraintRef.getPtr(refVa);
        return result;
    }

    @Override
    public VehicleConstraintRef toRef() {
        long refVa = this.va();
        long copyVa = VehicleConstraintRef.copy(refVa);
        VehicleConstraintRef result = new VehicleConstraintRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native long getPtr(long var0);
}

