/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.enumerate.ETransmissionMode;

public class VehicleTransmissionSettings
extends JoltPhysicsObject {
    public VehicleTransmissionSettings() {
        long settingsVa = VehicleTransmissionSettings.createDefault();
        this.setVirtualAddress(settingsVa, () -> VehicleTransmissionSettings.free(settingsVa));
    }

    VehicleTransmissionSettings(JoltPhysicsObject vehicle, long settingsVa) {
        super(vehicle, settingsVa);
    }

    public VehicleTransmissionSettings(VehicleTransmissionSettings original) {
        long originalVa = original.va();
        long copyVa = VehicleTransmissionSettings.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> VehicleTransmissionSettings.free(copyVa));
    }

    public float getClutchReleaseTime() {
        long settingsVa = this.va();
        float result = VehicleTransmissionSettings.getClutchReleaseTime(settingsVa);
        return result;
    }

    public float getClutchStrength() {
        long settingsVa = this.va();
        float result = VehicleTransmissionSettings.getClutchStrength(settingsVa);
        return result;
    }

    public float[] getGearRatios() {
        long settingsVa = this.va();
        float[] result = VehicleTransmissionSettings.getGearRatios(settingsVa);
        return result;
    }

    public ETransmissionMode getMode() {
        long settingsVa = this.va();
        int ordinal = VehicleTransmissionSettings.getMode(settingsVa);
        ETransmissionMode result = ETransmissionMode.values()[ordinal];
        return result;
    }

    public float[] getReverseGearRatios() {
        long settingsVa = this.va();
        float[] result = VehicleTransmissionSettings.getReverseGearRatios(settingsVa);
        return result;
    }

    public float getShiftDownRpm() {
        long settingsVa = this.va();
        float result = VehicleTransmissionSettings.getShiftDownRpm(settingsVa);
        return result;
    }

    public float getShiftUpRpm() {
        long settingsVa = this.va();
        float result = VehicleTransmissionSettings.getShiftUpRpm(settingsVa);
        return result;
    }

    public float getSwitchLatency() {
        long settingsVa = this.va();
        float result = VehicleTransmissionSettings.getSwitchLatency(settingsVa);
        return result;
    }

    public float getSwitchTime() {
        long settingsVa = this.va();
        float result = VehicleTransmissionSettings.getSwitchTime(settingsVa);
        return result;
    }

    public void setClutchReleaseTime(float latency) {
        long settingsVa = this.va();
        VehicleTransmissionSettings.setClutchStrength(settingsVa, latency);
    }

    public void setClutchStrength(float strength) {
        long settingsVa = this.va();
        VehicleTransmissionSettings.setClutchStrength(settingsVa, strength);
    }

    public void setGearRatios(float ... ratios) {
        long settingsVa = this.va();
        VehicleTransmissionSettings.setGearRatios(settingsVa, ratios);
    }

    public void setMode(ETransmissionMode mode) {
        long settingsVa = this.va();
        int ordinal = mode.ordinal();
        VehicleTransmissionSettings.setMode(settingsVa, ordinal);
    }

    public void setReverseGearRatios(float ... ratios) {
        long settingsVa = this.va();
        VehicleTransmissionSettings.setReverseGearRatios(settingsVa, ratios);
    }

    public void setShiftDownRpm(float rpm) {
        long settingsVa = this.va();
        VehicleTransmissionSettings.setShiftDownRpm(settingsVa, rpm);
    }

    public void setShiftUpRpm(float rpm) {
        long settingsVa = this.va();
        VehicleTransmissionSettings.setShiftUpRpm(settingsVa, rpm);
    }

    public void setSwitchLatency(float latency) {
        long settingsVa = this.va();
        VehicleTransmissionSettings.setSwitchLatency(settingsVa, latency);
    }

    public void setSwitchTime(float latency) {
        long settingsVa = this.va();
        VehicleTransmissionSettings.setSwitchTime(settingsVa, latency);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native float getClutchReleaseTime(long var0);

    private static native float getClutchStrength(long var0);

    private static native float[] getGearRatios(long var0);

    private static native int getMode(long var0);

    private static native float[] getReverseGearRatios(long var0);

    private static native float getShiftDownRpm(long var0);

    private static native float getShiftUpRpm(long var0);

    private static native float getSwitchLatency(long var0);

    private static native float getSwitchTime(long var0);

    private static native void setClutchStrength(long var0, float var2);

    private static native void setGearRatios(long var0, float[] var2);

    private static native void setMode(long var0, int var2);

    private static native void setReverseGearRatios(long var0, float[] var2);

    private static native void setShiftDownRpm(long var0, float var2);

    private static native void setShiftUpRpm(long var0, float var2);

    private static native void setSwitchLatency(long var0, float var2);

    private static native void setSwitchTime(long var0, float var2);
}

