/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Float3;
import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.readonly.ConstVertexList;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public final class VertexList
implements ConstVertexList {
    private static final int numAxes = 3;
    private boolean allowModification = true;
    private FloatBuffer buffer = Jolt.newDirectFloatBuffer(99);

    public VertexList() {
        this.buffer.flip();
    }

    public void pushBack(Float3 location) {
        int numElements = this.size();
        this.resize(numElements + 1);
        this.set(numElements, location);
    }

    public void resize(int numVertices) {
        if (!this.allowModification) {
            throw new IllegalStateException("Modification is no longer allowed.");
        }
        int numFloats = numVertices * 3;
        if (numFloats > this.buffer.capacity()) {
            FloatBuffer oldBuffer = this.buffer.rewind();
            this.buffer = Jolt.newDirectFloatBuffer(numFloats);
            while (oldBuffer.hasRemaining()) {
                float x = oldBuffer.get();
                this.buffer.put(x);
            }
            this.buffer.flip();
        }
        this.buffer.limit(numFloats);
    }

    public void set(int vertexIndex, float x, float y, float z) {
        if (!this.allowModification) {
            throw new IllegalStateException("Modification is no longer allowed.");
        }
        this.buffer.put(3 * vertexIndex, x);
        this.buffer.put(3 * vertexIndex + 1, y);
        this.buffer.put(3 * vertexIndex + 2, z);
    }

    public void set(int vertexIndex, Float3 location) {
        this.set(vertexIndex, location.x, location.y, location.z);
    }

    public void set(int vertexIndex, Vec3Arg location) {
        this.set(vertexIndex, location.getX(), location.getY(), location.getZ());
    }

    @Override
    public int capacity() {
        int result = this.buffer.capacity() / 3;
        return result;
    }

    @Override
    public boolean empty() {
        return this.buffer.limit() == 0;
    }

    @Override
    public Float3 get(int listIndex) {
        float x = this.buffer.get(3 * listIndex);
        float y = this.buffer.get(3 * listIndex + 1);
        float z = this.buffer.get(3 * listIndex + 2);
        Float3 result = new Float3(x, y, z);
        return result;
    }

    @Override
    public int size() {
        int result = this.buffer.limit() / 3;
        return result;
    }

    @Override
    public FloatBuffer toDirectBuffer() {
        this.allowModification = false;
        return this.buffer;
    }
}

