/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Rtti;
import com.github.stephengold.joltjni.SerializableObject;
import com.github.stephengold.joltjni.SpringSettings;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.WheelSettingsTv;
import com.github.stephengold.joltjni.WheelSettingsWv;
import com.github.stephengold.joltjni.readonly.ConstWheelSettings;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.template.Ref;
import java.nio.FloatBuffer;

public abstract class WheelSettings
extends SerializableObject
implements ConstWheelSettings {
    WheelSettings() {
    }

    static WheelSettings newSettings(long settingsVa) {
        WheelSettings result;
        String typeName;
        if (settingsVa == 0L) {
            return null;
        }
        long rttiVa = SerializableObject.getRtti(settingsVa);
        switch (typeName = Rtti.getName(rttiVa)) {
            case "WheelSettingsTV": {
                result = new WheelSettingsTv(settingsVa);
                break;
            }
            case "WheelSettingsWV": {
                result = new WheelSettingsWv(settingsVa);
                break;
            }
            default: {
                throw new RuntimeException("typeName = " + typeName);
            }
        }
        assert (result instanceof SerializableObject);
        return result;
    }

    public void restoreBinaryState(StreamIn stream) {
        long settingsVa = this.va();
        long streamVa = stream.va();
        WheelSettings.restoreBinaryState(settingsVa, streamVa);
    }

    public WheelSettings setEnableSuspensionForcePoint(boolean enable) {
        long settingsVa = this.va();
        WheelSettings.setEnableSuspensionForcePoint(settingsVa, enable);
        return this;
    }

    public WheelSettings setPosition(Vec3Arg position) {
        long settingsVa = this.va();
        float x = position.getX();
        float y = position.getY();
        float z = position.getZ();
        WheelSettings.setPosition(settingsVa, x, y, z);
        return this;
    }

    public WheelSettings setRadius(float radius) {
        long settingsVa = this.va();
        WheelSettings.setRadius(settingsVa, radius);
        return this;
    }

    public WheelSettings setSteeringAxis(Vec3Arg direction) {
        long settingsVa = this.va();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        WheelSettings.setSteeringAxis(settingsVa, dx, dy, dz);
        return this;
    }

    public WheelSettings setSuspensionDirection(Vec3Arg direction) {
        long settingsVa = this.va();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        WheelSettings.setSuspensionDirection(settingsVa, dx, dy, dz);
        return this;
    }

    public WheelSettings setSuspensionForcePoint(Vec3Arg location) {
        long settingsVa = this.va();
        float x = location.getX();
        float y = location.getY();
        float z = location.getZ();
        WheelSettings.setSuspensionForcePoint(settingsVa, x, y, z);
        return this;
    }

    public WheelSettings setSuspensionMaxLength(float length) {
        long settingsVa = this.va();
        WheelSettings.setSuspensionMaxLength(settingsVa, length);
        return this;
    }

    public WheelSettings setSuspensionMinLength(float length) {
        long settingsVa = this.va();
        WheelSettings.setSuspensionMinLength(settingsVa, length);
        return this;
    }

    public WheelSettings setSuspensionPreloadLength(float length) {
        long settingsVa = this.va();
        WheelSettings.setSuspensionPreloadLength(settingsVa, length);
        return this;
    }

    public WheelSettings setWheelForward(Vec3Arg direction) {
        long settingsVa = this.va();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        WheelSettings.setWheelForward(settingsVa, dx, dy, dz);
        return this;
    }

    public WheelSettings setWheelUp(Vec3Arg direction) {
        long settingsVa = this.va();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        WheelSettings.setWheelUp(settingsVa, dx, dy, dz);
        return this;
    }

    public WheelSettings setWidth(float width) {
        long settingsVa = this.va();
        WheelSettings.setWidth(settingsVa, width);
        return this;
    }

    @Override
    public boolean getEnableSuspensionForcePoint() {
        long settingsVa = this.va();
        boolean result = WheelSettings.getEnableSuspensionForcePoint(settingsVa);
        return result;
    }

    @Override
    public Vec3 getPosition() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        WheelSettings.getPosition(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getRadius() {
        long settingsVa = this.va();
        float result = WheelSettings.getRadius(settingsVa);
        return result;
    }

    @Override
    public Vec3 getSteeringAxis() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        WheelSettings.getSteeringAxis(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getSuspensionDirection() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        WheelSettings.getSuspensionDirection(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getSuspensionForcePoint() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        WheelSettings.getSuspensionForcePoint(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getSuspensionMaxLength() {
        long settingsVa = this.va();
        float result = WheelSettings.getSuspensionMaxLength(settingsVa);
        return result;
    }

    @Override
    public float getSuspensionMinLength() {
        long settingsVa = this.va();
        float result = WheelSettings.getSuspensionMinLength(settingsVa);
        return result;
    }

    @Override
    public float getSuspensionPreloadLength() {
        long settingsVa = this.va();
        float result = WheelSettings.getSuspensionPreloadLength(settingsVa);
        return result;
    }

    @Override
    public SpringSettings getSuspensionSpring() {
        long wheelSettingsVa = this.va();
        long springSettingsVa = WheelSettings.getSuspensionSpring(wheelSettingsVa);
        SpringSettings result = new SpringSettings(this, springSettingsVa);
        return result;
    }

    @Override
    public Vec3 getWheelForward() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        WheelSettings.getWheelForward(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getWheelUp() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        WheelSettings.getWheelUp(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getWidth() {
        long settingsVa = this.va();
        float result = WheelSettings.getWidth(settingsVa);
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long settingsVa = this.va();
        long streamVa = stream.va();
        WheelSettings.saveBinaryState(settingsVa, streamVa);
    }

    @Override
    public abstract int getRefCount();

    @Override
    public abstract void setEmbedded();

    @Override
    public abstract Ref toRef();

    static native boolean getEnableSuspensionForcePoint(long var0);

    static native void getPosition(long var0, FloatBuffer var2);

    static native float getRadius(long var0);

    static native void getSteeringAxis(long var0, FloatBuffer var2);

    static native void getSuspensionDirection(long var0, FloatBuffer var2);

    static native void getSuspensionForcePoint(long var0, FloatBuffer var2);

    static native float getSuspensionMaxLength(long var0);

    static native float getSuspensionMinLength(long var0);

    static native float getSuspensionPreloadLength(long var0);

    static native long getSuspensionSpring(long var0);

    static native void getWheelForward(long var0, FloatBuffer var2);

    static native void getWheelUp(long var0, FloatBuffer var2);

    static native float getWidth(long var0);

    private static native void restoreBinaryState(long var0, long var2);

    static native void saveBinaryState(long var0, long var2);

    static native void setEnableSuspensionForcePoint(long var0, boolean var2);

    static native void setPosition(long var0, float var2, float var3, float var4);

    static native void setRadius(long var0, float var2);

    static native void setSteeringAxis(long var0, float var2, float var3, float var4);

    static native void setSuspensionDirection(long var0, float var2, float var3, float var4);

    static native void setSuspensionForcePoint(long var0, float var2, float var3, float var4);

    static native void setSuspensionMaxLength(long var0, float var2);

    static native void setSuspensionMinLength(long var0, float var2);

    static native void setSuspensionPreloadLength(long var0, float var2);

    static native void setWheelForward(long var0, float var2, float var3, float var4);

    static native void setWheelUp(long var0, float var2, float var3, float var4);

    static native void setWidth(long var0, float var2);
}

