/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.WheelSettings;
import com.github.stephengold.joltjni.WheelSettingsTvRef;
import com.github.stephengold.joltjni.readonly.ConstWheelSettingsTv;

public class WheelSettingsTv
extends WheelSettings
implements ConstWheelSettingsTv {
    public WheelSettingsTv() {
        long settingsVa = WheelSettingsTv.createDefault();
        long refVa = WheelSettingsTv.toRef(settingsVa);
        Runnable freeingAction = () -> WheelSettingsTvRef.free(refVa);
        this.setVirtualAddress(settingsVa, freeingAction);
    }

    public WheelSettingsTv(ConstWheelSettingsTv original) {
        long originalVa = original.targetVa();
        long copyVa = WheelSettingsTv.createCopy(originalVa);
        long refVa = WheelSettingsTv.toRef(copyVa);
        Runnable freeingAction = () -> WheelSettingsTvRef.free(refVa);
        this.setVirtualAddress(copyVa, freeingAction);
    }

    WheelSettingsTv(long settingsVa) {
        long refVa = WheelSettingsTv.toRef(settingsVa);
        Runnable freeingAction = () -> WheelSettingsTvRef.free(refVa);
        this.setVirtualAddress(settingsVa, freeingAction);
    }

    public void setLateralFriction(float friction) {
        long settingsVa = this.va();
        WheelSettingsTv.setLateralFriction(settingsVa, friction);
    }

    public void setLongitudinalFriction(float friction) {
        long settingsVa = this.va();
        WheelSettingsTv.setLongitudinalFriction(settingsVa, friction);
    }

    @Override
    public float getLateralFriction() {
        long settingsVa = this.va();
        float result = WheelSettingsTv.getLateralFriction(settingsVa);
        return result;
    }

    @Override
    public float getLongitudinalFriction() {
        long settingsVa = this.va();
        float result = WheelSettingsTv.getLongitudinalFriction(settingsVa);
        return result;
    }

    @Override
    public int getRefCount() {
        long settingsVa = this.va();
        int result = WheelSettingsTv.getRefCount(settingsVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long settingsVa = this.va();
        WheelSettingsTv.setEmbedded(settingsVa);
    }

    @Override
    public WheelSettingsTvRef toRef() {
        long settingsVa = this.va();
        long refVa = WheelSettingsTv.toRef(settingsVa);
        WheelSettingsTvRef result = new WheelSettingsTvRef(refVa, true);
        return result;
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    static native float getLateralFriction(long var0);

    static native float getLongitudinalFriction(long var0);

    private static native int getRefCount(long var0);

    private static native void setEmbedded(long var0);

    static native void setLateralFriction(long var0, float var2);

    static native void setLongitudinalFriction(long var0, float var2);

    private static native long toRef(long var0);
}

