/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.WheelSettings;
import com.github.stephengold.joltjni.WheelSettingsWvRef;
import com.github.stephengold.joltjni.readonly.ConstWheelSettingsWv;

public class WheelSettingsWv
extends WheelSettings
implements ConstWheelSettingsWv {
    public WheelSettingsWv() {
        long settingsVa = WheelSettingsWv.createDefault();
        long refVa = WheelSettingsWv.toRef(settingsVa);
        Runnable freeingAction = () -> WheelSettingsWvRef.free(refVa);
        this.setVirtualAddress(settingsVa, freeingAction);
    }

    public WheelSettingsWv(ConstWheelSettingsWv original) {
        long originalVa = original.targetVa();
        long copyVa = WheelSettingsWv.createCopy(originalVa);
        long refVa = WheelSettingsWv.toRef(copyVa);
        Runnable freeingAction = () -> WheelSettingsWvRef.free(refVa);
        this.setVirtualAddress(copyVa, freeingAction);
    }

    WheelSettingsWv(long settingsVa) {
        long refVa = WheelSettingsWv.toRef(settingsVa);
        Runnable freeingAction = () -> WheelSettingsWvRef.free(refVa);
        this.setVirtualAddress(settingsVa, freeingAction);
    }

    public void setMaxBrakeTorque(float torque) {
        long settingsVa = this.va();
        WheelSettingsWv.setMaxBrakeTorque(settingsVa, torque);
    }

    public void setMaxHandBrakeTorque(float torque) {
        long settingsVa = this.va();
        WheelSettingsWv.setMaxHandBrakeTorque(settingsVa, torque);
    }

    public void setMaxSteerAngle(float angle) {
        long settingsVa = this.va();
        WheelSettingsWv.setMaxSteerAngle(settingsVa, angle);
    }

    @Override
    public float getMaxBrakeTorque() {
        long settingsVa = this.va();
        float result = WheelSettingsWv.getMaxBrakeTorque(settingsVa);
        return result;
    }

    @Override
    public float getMaxHandBrakeTorque() {
        long settingsVa = this.va();
        float result = WheelSettingsWv.getMaxHandBrakeTorque(settingsVa);
        return result;
    }

    @Override
    public float getMaxSteerAngle() {
        long settingsVa = this.va();
        float result = WheelSettingsWv.getMaxSteerAngle(settingsVa);
        return result;
    }

    @Override
    public int getRefCount() {
        long settingsVa = this.va();
        int result = WheelSettingsWv.getRefCount(settingsVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long settingsVa = this.va();
        WheelSettingsWv.setEmbedded(settingsVa);
    }

    @Override
    public WheelSettingsWvRef toRef() {
        long settingsVa = this.va();
        long refVa = WheelSettingsWv.toRef(settingsVa);
        WheelSettingsWvRef result = new WheelSettingsWvRef(refVa, true);
        return result;
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    static native float getMaxBrakeTorque(long var0);

    static native float getMaxHandBrakeTorque(long var0);

    static native float getMaxSteerAngle(long var0);

    private static native int getRefCount(long var0);

    private static native void setEmbedded(long var0);

    static native void setMaxBrakeTorque(long var0, float var2);

    static native void setMaxHandBrakeTorque(long var0, float var2);

    static native void setMaxSteerAngle(long var0, float var2);

    private static native long toRef(long var0);
}

