/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni.vhacd;

import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import java.nio.FloatBuffer;

public class ConvexHull
extends JoltPhysicsObject {
    private static final int numAxes = 3;

    ConvexHull(long hullVa, boolean owner) {
        Runnable freeingAction = owner ? () -> ConvexHull.free(hullVa) : null;
        this.setVirtualAddress(hullVa, freeingAction);
    }

    public int countPoints() {
        long hullVa = this.va();
        int result = ConvexHull.countPoints(hullVa);
        return result;
    }

    public FloatBuffer getPointsAsBuffer() {
        long hullVa = this.va();
        int numPoints = ConvexHull.countPoints(hullVa);
        int numFloats = numPoints * 3;
        assert (numFloats > 0) : numFloats;
        FloatBuffer result = Jolt.newDirectFloatBuffer(numFloats);
        ConvexHull.copyPoints(hullVa, result);
        return result;
    }

    private static native void copyPoints(long var0, FloatBuffer var2);

    private static native int countPoints(long var0);

    private static native void free(long var0);
}

