/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.rope;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.UUID;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.VxRenderState;
import net.xmx.velthoric.physics.object.client.body.VxClientSoftBody;
import net.xmx.velthoric.physics.object.sync.VxDataAccessor;
import net.xmx.velthoric.physics.object.sync.VxDataSerializers;

public class RopeClientSoftBody
extends VxClientSoftBody {
    private static final VxDataAccessor<Float> DATA_ROPE_RADIUS = VxDataAccessor.create(RopeClientSoftBody.class, VxDataSerializers.FLOAT);
    private static final class_2960 YELLOW_WOOL_BLOCK_TEXTURE = new class_2960("minecraft:block/yellow_wool");
    private static final int SIDES = 12;
    private static final Vec3 JOLT_UNIT_X = new Vec3(1.0f, 0.0f, 0.0f);
    private static final Vec3 JOLT_UNIT_Y = new Vec3(0.0f, 1.0f, 0.0f);

    public RopeClientSoftBody(UUID id, VxClientObjectManager manager, int dataStoreIndex, EBodyType objectType) {
        super(id, manager, dataStoreIndex, objectType);
    }

    @Override
    protected void defineSyncData() {
        this.synchronizedData.define(DATA_ROPE_RADIUS, Float.valueOf(0.1f));
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        float[] renderVertexData = renderState.vertexData;
        if (renderVertexData == null || renderVertexData.length < 6) {
            return;
        }
        float ropeRadius = this.getSyncData(DATA_ROPE_RADIUS).floatValue();
        if (ropeRadius <= 0.0f) {
            return;
        }
        int numNodes = renderVertexData.length / 3;
        this.renderSmoothRope(renderVertexData, numNodes, ropeRadius, poseStack, (class_4597)bufferSource, packedLight);
    }

    private void renderSmoothRope(float[] vertexData, int numNodes, float ropeRadius, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        int nodeIdx;
        int i;
        class_4588 buffer = bufferSource.getBuffer(class_1921.method_23579());
        class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(YELLOW_WOOL_BLOCK_TEXTURE);
        Vec3[][] ringVertices = new Vec3[numNodes][12];
        Vec3[] nodePositions = new Vec3[numNodes];
        Vec3[] directions = new Vec3[numNodes];
        for (i = 0; i < numNodes; ++i) {
            nodePositions[i] = new Vec3(vertexData[i * 3], vertexData[i * 3 + 1], vertexData[i * 3 + 2]);
        }
        for (i = 0; i < numNodes; ++i) {
            Vec3 direction = i == 0 ? Op.minus(nodePositions[1], (Vec3Arg)nodePositions[0]) : (i == numNodes - 1 ? Op.minus(nodePositions[i], (Vec3Arg)nodePositions[i - 1]) : Op.plus((Vec3Arg)Op.minus(nodePositions[i + 1], (Vec3Arg)nodePositions[i]), (Vec3Arg)Op.minus(nodePositions[i], (Vec3Arg)nodePositions[i - 1])));
            if (direction.lengthSq() < 1.0E-12f) {
                direction.set(0.0f, -1.0f, 0.0f);
            }
            directions[i] = direction.normalized();
        }
        Vec3 lastUp = Math.abs(directions[0].dot(JOLT_UNIT_Y)) > 0.99f ? directions[0].cross(JOLT_UNIT_X).normalized() : Op.star((Vec3Arg)directions[0].cross(JOLT_UNIT_Y).normalized(), -1.0f);
        for (nodeIdx = 0; nodeIdx < numNodes; ++nodeIdx) {
            Vec3 direction = directions[nodeIdx];
            if (nodeIdx > 0) {
                lastUp = Op.star((QuatArg)Quat.sFromTo(directions[nodeIdx - 1], direction), (Vec3Arg)lastUp);
            }
            Vec3 right = direction.cross(lastUp).normalized();
            for (int sideIdx = 0; sideIdx < 12; ++sideIdx) {
                float angle = (float)sideIdx * 0.5235988f;
                Vec3 offset = Op.plus((Vec3Arg)Op.star((Vec3Arg)right, (float)Math.cos(angle) * ropeRadius), (Vec3Arg)Op.star((Vec3Arg)lastUp, (float)Math.sin(angle) * ropeRadius));
                ringVertices[nodeIdx][sideIdx] = Op.plus((Vec3Arg)nodePositions[nodeIdx], (Vec3Arg)offset);
            }
        }
        for (nodeIdx = 0; nodeIdx < numNodes - 1; ++nodeIdx) {
            for (int sideIdx = 0; sideIdx < 12; ++sideIdx) {
                int nextSideIdx = (sideIdx + 1) % 12;
                Vec3 v00 = ringVertices[nodeIdx][sideIdx];
                Vec3 v01 = ringVertices[nodeIdx][nextSideIdx];
                Vec3 v10 = ringVertices[nodeIdx + 1][sideIdx];
                Vec3 v11 = ringVertices[nodeIdx + 1][nextSideIdx];
                Vec3 normal = Op.minus(v01, (Vec3Arg)v00).cross(Op.minus(v10, (Vec3Arg)v00)).normalized();
                if (normal.lengthSq() < 1.0E-9f) {
                    normal.set(0.0f, 1.0f, 0.0f);
                }
                this.addQuad(buffer, poseStack, v00, v10, v11, v01, normal, packedLight, sprite);
            }
        }
    }

    private void addQuad(class_4588 buffer, class_4587 poseStack, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, Vec3 normal, int packedLight, class_1058 sprite) {
        class_4587.class_4665 last = poseStack.method_23760();
        buffer.method_22918(last.method_23761(), v1.getX(), v1.getY(), v1.getZ()).method_1336(255, 255, 255, 255).method_22913(sprite.method_4594(), sprite.method_4593()).method_22916(packedLight).method_23763(last.method_23762(), normal.getX(), normal.getY(), normal.getZ()).method_1344();
        buffer.method_22918(last.method_23761(), v2.getX(), v2.getY(), v2.getZ()).method_1336(255, 255, 255, 255).method_22913(sprite.method_4577(), sprite.method_4593()).method_22916(packedLight).method_23763(last.method_23762(), normal.getX(), normal.getY(), normal.getZ()).method_1344();
        buffer.method_22918(last.method_23761(), v3.getX(), v3.getY(), v3.getZ()).method_1336(255, 255, 255, 255).method_22913(sprite.method_4577(), sprite.method_4575()).method_22916(packedLight).method_23763(last.method_23762(), normal.getX(), normal.getY(), normal.getZ()).method_1344();
        buffer.method_22918(last.method_23761(), v4.getX(), v4.getY(), v4.getZ()).method_1336(255, 255, 255, 255).method_22913(sprite.method_4594(), sprite.method_4575()).method_22916(packedLight).method_23763(last.method_23762(), normal.getX(), normal.getY(), normal.getZ()).method_1344();
    }
}

