/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.rope;

import com.github.stephengold.joltjni.Edge;
import com.github.stephengold.joltjni.SoftBodyCreationSettings;
import com.github.stephengold.joltjni.SoftBodySharedSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.Vertex;
import java.util.UUID;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.object.VxObjectType;
import net.xmx.velthoric.physics.object.sync.VxDataAccessor;
import net.xmx.velthoric.physics.object.sync.VxDataSerializers;
import net.xmx.velthoric.physics.object.type.VxSoftBody;
import net.xmx.velthoric.physics.object.type.factory.VxSoftBodyFactory;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class RopeSoftBody
extends VxSoftBody {
    private static final VxDataAccessor<Float> DATA_ROPE_RADIUS = VxDataAccessor.create(RopeSoftBody.class, VxDataSerializers.FLOAT);
    private float ropeLength = 10.0f;
    private int numSegments = 20;
    private float mass = 5.0f;
    private float compliance = 0.001f;

    public RopeSoftBody(VxObjectType<RopeSoftBody> type, VxPhysicsWorld world, UUID id) {
        super((VxObjectType<? extends VxSoftBody>)type, world, id);
    }

    @Override
    protected void defineSyncData() {
        this.synchronizedData.define(DATA_ROPE_RADIUS, Float.valueOf(0.1f));
    }

    public void setConfiguration(float ropeLength, int numSegments, float ropeRadius, float mass, float compliance) {
        this.ropeLength = ropeLength;
        this.numSegments = numSegments;
        this.setSyncData(DATA_ROPE_RADIUS, Float.valueOf(ropeRadius));
        this.mass = mass;
        this.compliance = compliance;
    }

    @Override
    public int createJoltBody(VxSoftBodyFactory factory) {
        try (SoftBodySharedSettings sharedSettings = new SoftBodySharedSettings();){
            int n;
            try (SoftBodyCreationSettings creationSettings = new SoftBodyCreationSettings();){
                int i;
                int safeNumSegments = Math.max(1, this.numSegments);
                float safeMass = Math.max(0.001f, this.mass);
                int numNodes = safeNumSegments + 1;
                float segmentLength = this.ropeLength / (float)safeNumSegments;
                float invMassPerNode = safeMass > 0.0f ? (float)numNodes / safeMass : 0.0f;
                for (i = 0; i < numNodes; ++i) {
                    sharedSettings.addVertex(new Vertex().setPosition(new Vec3(0.0f, (float)(-i) * segmentLength, 0.0f)).setInvMass(invMassPerNode));
                }
                for (i = 0; i < numNodes - 1; ++i) {
                    Edge edge = new Edge();
                    edge.setVertex(0, i);
                    edge.setVertex(1, i + 1);
                    edge.setCompliance(this.compliance);
                    edge.setRestLength(segmentLength);
                    sharedSettings.addEdgeConstraint(edge);
                }
                sharedSettings.optimize();
                creationSettings.setSettings(sharedSettings);
                creationSettings.setObjectLayer(1);
                creationSettings.setVertexRadius(this.getSyncData(DATA_ROPE_RADIUS).floatValue());
                n = factory.create(sharedSettings, creationSettings);
            }
            return n;
        }
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        buf.writeFloat(this.ropeLength);
        buf.writeInt(this.numSegments);
        buf.writeFloat(this.getSyncData(DATA_ROPE_RADIUS).floatValue());
        buf.writeFloat(this.mass);
        buf.writeFloat(this.compliance);
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        this.ropeLength = buf.readFloat();
        this.numSegments = buf.readInt();
        this.setSyncData(DATA_ROPE_RADIUS, Float.valueOf(buf.readFloat()));
        this.mass = buf.readFloat();
        this.compliance = buf.readFloat();
    }
}

