/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.sphere;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import java.util.UUID;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.VxRenderState;
import net.xmx.velthoric.physics.object.client.body.VxClientRigidBody;
import net.xmx.velthoric.physics.object.sync.VxDataAccessor;
import net.xmx.velthoric.physics.object.sync.VxDataSerializers;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SphereClientRigidBody
extends VxClientRigidBody {
    private static final VxDataAccessor<Float> DATA_RADIUS = VxDataAccessor.create(SphereClientRigidBody.class, VxDataSerializers.FLOAT);
    private static final int STACKS = 16;
    private static final int SECTORS = 32;

    public SphereClientRigidBody(UUID id, VxClientObjectManager manager, int dataStoreIndex, EBodyType objectType) {
        super(id, manager, dataStoreIndex, objectType);
    }

    @Override
    protected void defineSyncData() {
        this.synchronizedData.define(DATA_RADIUS, Float.valueOf(0.5f));
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        poseStack.method_22903();
        RVec3 renderPosition = renderState.transform.getTranslation();
        Quat renderRotation = renderState.transform.getRotation();
        poseStack.method_46416(renderPosition.x(), renderPosition.y(), renderPosition.z());
        poseStack.method_22907(new Quaternionf(renderRotation.getX(), renderRotation.getY(), renderRotation.getZ(), renderRotation.getW()));
        class_4587.class_4665 lastPose = poseStack.method_23760();
        Matrix4f poseMatrix = lastPose.method_23761();
        Matrix3f normalMatrix = lastPose.method_23762();
        class_4588 consumer = bufferSource.getBuffer(class_1921.method_23577());
        float radius = this.getSyncData(DATA_RADIUS).floatValue();
        int r = 200;
        int g = 50;
        int b = 50;
        int a = 255;
        for (int i = 0; i < 16; ++i) {
            float phi1 = (float)((double)i * Math.PI / 16.0);
            float phi2 = (float)((double)(i + 1) * Math.PI / 16.0);
            for (int j = 0; j < 32; ++j) {
                float theta1 = (float)((double)(j * 2) * Math.PI / 32.0);
                float theta2 = (float)((double)((j + 1) * 2) * Math.PI / 32.0);
                Vector3f v1 = this.getSphereVertex(radius, phi1, theta1);
                Vector3f v2 = this.getSphereVertex(radius, phi1, theta2);
                Vector3f v3 = this.getSphereVertex(radius, phi2, theta2);
                Vector3f v4 = this.getSphereVertex(radius, phi2, theta1);
                this.addVertex(consumer, poseMatrix, normalMatrix, v1, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v2, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v4, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v2, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v3, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v4, r, g, b, a, packedLight);
            }
        }
        poseStack.method_22909();
    }

    private Vector3f getSphereVertex(float radius, float phi, float theta) {
        float x = (float)((double)radius * Math.sin(phi) * Math.cos(theta));
        float y = (float)((double)radius * Math.cos(phi));
        float z = (float)((double)radius * Math.sin(phi) * Math.sin(theta));
        return new Vector3f(x, y, z);
    }

    private void addVertex(class_4588 consumer, Matrix4f poseMatrix, Matrix3f normalMatrix, Vector3f pos, int r, int g, int b, int a, int packedLight) {
        Vector3f normal = new Vector3f((Vector3fc)pos).normalize();
        consumer.method_22918(poseMatrix, pos.x, pos.y, pos.z).method_1336(r, g, b, a).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(packedLight).method_23763(normalMatrix, normal.x, normal.y, normal.z).method_1344();
    }
}

