/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.sphere;

import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.SphereShapeSettings;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import java.util.UUID;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.object.VxObjectType;
import net.xmx.velthoric.physics.object.sync.VxDataAccessor;
import net.xmx.velthoric.physics.object.sync.VxDataSerializers;
import net.xmx.velthoric.physics.object.type.VxRigidBody;
import net.xmx.velthoric.physics.object.type.factory.VxRigidBodyFactory;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class SphereRigidBody
extends VxRigidBody {
    private static final VxDataAccessor<Float> DATA_RADIUS = VxDataAccessor.create(SphereRigidBody.class, VxDataSerializers.FLOAT);

    public SphereRigidBody(VxObjectType<SphereRigidBody> type, VxPhysicsWorld world, UUID id) {
        super((VxObjectType<? extends VxRigidBody>)type, world, id);
    }

    @Override
    protected void defineSyncData() {
        this.synchronizedData.define(DATA_RADIUS, Float.valueOf(0.5f));
    }

    public void setRadius(float radius) {
        this.setSyncData(DATA_RADIUS, Float.valueOf(radius > 0.0f ? radius : 0.5f));
    }

    public float getRadius() {
        return this.getSyncData(DATA_RADIUS).floatValue();
    }

    @Override
    public int createJoltBody(VxRigidBodyFactory factory) {
        try (SphereShapeSettings shapeSettings = new SphereShapeSettings(this.getRadius());){
            int n;
            try (BodyCreationSettings bcs = new BodyCreationSettings();){
                bcs.setMotionType(EMotionType.Dynamic);
                bcs.setObjectLayer(1);
                n = factory.create(shapeSettings, bcs);
            }
            return n;
        }
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        buf.writeFloat(this.getRadius());
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        this.setRadius(buf.readFloat());
    }
}

