/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.PointConstraintSettings;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.xmx.velthoric.builtin.VxRegisteredObjects;
import net.xmx.velthoric.builtin.box.BoxRigidBody;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.constraint.manager.VxConstraintManager;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class SpawnBoxNet
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnBoxNet";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9244((String)"start_position", (ArgumentType)class_2277.method_9735((boolean)true)).then(class_2170.method_9244((String)"sizeX", (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).then(class_2170.method_9244((String)"sizeY", (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).then(class_2170.method_9244((String)"sizeZ", (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).executes(this::execute)))));
    }

    private int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3218 serverLevel = source.method_9225();
        class_243 startPos = class_2277.method_9736(context, (String)"start_position");
        int sizeX = IntegerArgumentType.getInteger(context, (String)"sizeX");
        int sizeY = IntegerArgumentType.getInteger(context, (String)"sizeY");
        int sizeZ = IntegerArgumentType.getInteger(context, (String)"sizeZ");
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)serverLevel.method_27983());
        if (physicsWorld == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Physics system for this dimension is not initialized."));
            return 0;
        }
        physicsWorld.execute(() -> {
            int z;
            int y;
            int x;
            VxObjectManager objectManager = physicsWorld.getObjectManager();
            VxConstraintManager constraintManager = physicsWorld.getConstraintManager();
            float boxSize = 0.5f;
            float boxHalfExtent = boxSize / 2.0f;
            Vec3 boxHalfExtents = new Vec3(boxHalfExtent, boxHalfExtent, boxHalfExtent);
            BoxRigidBody[][][] gridBodies = new BoxRigidBody[sizeX][sizeY][sizeZ];
            for (x = 0; x < sizeX; ++x) {
                for (y = 0; y < sizeY; ++y) {
                    for (z = 0; z < sizeZ; ++z) {
                        RVec3 currentPosition = new RVec3(startPos.field_1352 + (double)((float)x * boxSize), startPos.field_1351 + (double)((float)y * boxSize), startPos.field_1350 + (double)((float)z * boxSize));
                        BoxRigidBody currentBody = objectManager.createRigidBody(VxRegisteredObjects.BOX, new VxTransform(currentPosition, Quat.sIdentity()), body -> body.setHalfExtents(boxHalfExtents));
                        if (currentBody == null) {
                            source.method_9213((class_2561)class_2561.method_43470((String)"Failed to create a grid segment. Aborting."));
                            return;
                        }
                        gridBodies[x][y][z] = currentBody;
                    }
                }
            }
            for (x = 0; x < sizeX; ++x) {
                for (y = 0; y < sizeY; ++y) {
                    for (z = 0; z < sizeZ; ++z) {
                        PointConstraintSettings settings;
                        BoxRigidBody body2;
                        BoxRigidBody body1 = gridBodies[x][y][z];
                        if (x < sizeX - 1) {
                            body2 = gridBodies[x + 1][y][z];
                            settings = new PointConstraintSettings();
                            try {
                                settings.setSpace(EConstraintSpace.LocalToBodyCom);
                                settings.setPoint1(new RVec3(boxHalfExtent, 0.0, 0.0));
                                settings.setPoint2(new RVec3(-boxHalfExtent, 0.0, 0.0));
                                constraintManager.createConstraint(settings, body1.getPhysicsId(), body2.getPhysicsId());
                            }
                            finally {
                                settings.close();
                            }
                        }
                        if (y < sizeY - 1) {
                            body2 = gridBodies[x][y + 1][z];
                            settings = new PointConstraintSettings();
                            try {
                                settings.setSpace(EConstraintSpace.LocalToBodyCom);
                                settings.setPoint1(new RVec3(0.0, boxHalfExtent, 0.0));
                                settings.setPoint2(new RVec3(0.0, -boxHalfExtent, 0.0));
                                constraintManager.createConstraint(settings, body1.getPhysicsId(), body2.getPhysicsId());
                            }
                            finally {
                                settings.close();
                            }
                        }
                        if (z >= sizeZ - 1) continue;
                        body2 = gridBodies[x][y][z + 1];
                        settings = new PointConstraintSettings();
                        try {
                            settings.setSpace(EConstraintSpace.LocalToBodyCom);
                            settings.setPoint1(new RVec3(0.0, 0.0, boxHalfExtent));
                            settings.setPoint2(new RVec3(0.0, 0.0, -boxHalfExtent));
                            constraintManager.createConstraint(settings, body1.getPhysicsId(), body2.getPhysicsId());
                            continue;
                        }
                        finally {
                            settings.close();
                        }
                    }
                }
            }
            source.method_9226(() -> class_2561.method_43470((String)String.format("Successfully created a %d x %d x %d box grid.", sizeX, sizeY, sizeZ)), true);
        });
        return 1;
    }
}

