/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.PointConstraintSettings;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.xmx.velthoric.builtin.VxRegisteredObjects;
import net.xmx.velthoric.builtin.box.BoxRigidBody;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.constraint.manager.VxConstraintManager;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class SpawnChainedBoxes
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnChainedBoxes";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9244((String)"start_position", (ArgumentType)class_2277.method_9735((boolean)true)).then(class_2170.method_9244((String)"segments", (ArgumentType)IntegerArgumentType.integer((int)2, (int)1000)).executes(this::execute)));
    }

    private int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3218 serverLevel = source.method_9225();
        class_243 startPos = class_2277.method_9736(context, (String)"start_position");
        int numSegments = IntegerArgumentType.getInteger(context, (String)"segments");
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)serverLevel.method_27983());
        if (physicsWorld == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Physics system for this dimension is not initialized."));
            return 0;
        }
        physicsWorld.execute(() -> {
            VxObjectManager objectManager = physicsWorld.getObjectManager();
            VxConstraintManager constraintManager = physicsWorld.getConstraintManager();
            float segmentLength = 0.5f;
            float segmentRadius = 0.25f;
            Vec3 segmentHalfExtents = new Vec3(segmentRadius, segmentLength / 2.0f, segmentRadius);
            RVec3 anchorPosition = new RVec3(startPos.field_1352, startPos.field_1351, startPos.field_1350);
            BoxRigidBody anchorBody = objectManager.createRigidBody(VxRegisteredObjects.BOX, new VxTransform(anchorPosition, Quat.sIdentity()), body -> body.setHalfExtents(segmentHalfExtents));
            if (anchorBody == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Failed to create rope anchor."));
                return;
            }
            physicsWorld.getBodyInterface().setMotionType(anchorBody.getBodyId(), EMotionType.Kinematic, EActivation.DontActivate);
            BoxRigidBody previousBody = anchorBody;
            for (int i = 1; i < numSegments; ++i) {
                RVec3 currentPosition = new RVec3(startPos.field_1352, startPos.field_1351 - (double)((float)i * segmentLength), startPos.field_1350);
                BoxRigidBody currentBody = objectManager.createRigidBody(VxRegisteredObjects.BOX, new VxTransform(currentPosition, Quat.sIdentity()), body -> body.setHalfExtents(segmentHalfExtents));
                if (currentBody == null) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"Failed to create a rope segment. Aborting."));
                    return;
                }
                try (PointConstraintSettings settings = new PointConstraintSettings();){
                    settings.setSpace(EConstraintSpace.LocalToBodyCom);
                    settings.setNumPositionStepsOverride(4);
                    settings.setNumVelocityStepsOverride(4);
                    RVec3 pivotOnPrevious = new RVec3(0.0, -segmentLength / 2.0f, 0.0);
                    RVec3 pivotOnCurrent = new RVec3(0.0, segmentLength / 2.0f, 0.0);
                    settings.setPoint1(pivotOnPrevious);
                    settings.setPoint2(pivotOnCurrent);
                    constraintManager.createConstraint(settings, previousBody.getPhysicsId(), currentBody.getPhysicsId());
                }
                previousBody = currentBody;
            }
            source.method_9226(() -> class_2561.method_43470((String)String.format("Successfully created a rope with %d segments.", numSegments)), true);
        });
        return 1;
    }
}

