/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.xmx.velthoric.builtin.VxRegisteredObjects;
import net.xmx.velthoric.builtin.marble.MarbleRigidBody;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class SpawnMarbleTest
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnMarble";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9735((boolean)true)).executes(this::execute)).then(class_2170.method_9244((String)"radius", (ArgumentType)FloatArgumentType.floatArg((float)0.05f)).executes(this::executeWithRadius)));
    }

    private int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        return this.spawnMarble(context, 0.15f);
    }

    private int executeWithRadius(CommandContext<class_2168> context) throws CommandSyntaxException {
        float radius = FloatArgumentType.getFloat(context, (String)"radius");
        return this.spawnMarble(context, radius);
    }

    private int spawnMarble(CommandContext<class_2168> context, float radius) throws CommandSyntaxException {
        VxTransform transform;
        class_2168 source = (class_2168)context.getSource();
        class_3218 level = source.method_9225();
        class_243 pos = class_2277.method_9736(context, (String)"pos");
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)level.method_27983());
        if (physicsWorld == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"The physics system for this dimension is not initialized."));
            return 0;
        }
        VxObjectManager manager = physicsWorld.getObjectManager();
        MarbleRigidBody spawnedMarble = manager.createRigidBody(VxRegisteredObjects.MARBLE, transform = new VxTransform(new RVec3(pos.method_10216(), pos.method_10214(), pos.method_10215()), Quat.sIdentity()), marble -> marble.setRadius(radius));
        if (spawnedMarble != null) {
            source.method_9226(() -> class_2561.method_43470((String)("Successfully spawned a marble with radius " + radius + ".")), true);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Failed to spawn the marble. Check the server logs."));
        return 0;
    }
}

