/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.xmx.velthoric.builtin.VxRegisteredObjects;
import net.xmx.velthoric.builtin.rope.RopeSoftBody;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class SpawnRopeTest
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnRope";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9735((boolean)true)).then(class_2170.method_9244((String)"length", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(class_2170.method_9244((String)"radius", (ArgumentType)FloatArgumentType.floatArg((float)0.01f)).then(class_2170.method_9244((String)"mass", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(class_2170.method_9244((String)"segments", (ArgumentType)IntegerArgumentType.integer((int)2, (int)100)).executes(this::execute))))));
    }

    private int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        VxTransform transform;
        class_2168 source = (class_2168)context.getSource();
        class_3218 level = source.method_9225();
        class_243 pos = class_2277.method_9736(context, (String)"position");
        float length = FloatArgumentType.getFloat(context, (String)"length");
        float radius = FloatArgumentType.getFloat(context, (String)"radius");
        float mass = FloatArgumentType.getFloat(context, (String)"mass");
        int segments = IntegerArgumentType.getInteger(context, (String)"segments");
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)level.method_27983());
        if (physicsWorld == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Physics system for this dimension is not initialized."));
            return 0;
        }
        VxObjectManager manager = physicsWorld.getObjectManager();
        RopeSoftBody spawnedRope = manager.createSoftBody(VxRegisteredObjects.ROPE, transform = new VxTransform(new RVec3(pos.method_10216(), pos.method_10214(), pos.method_10215()), Quat.sIdentity()), rope -> rope.setConfiguration(length, segments, radius, mass, 0.001f));
        if (spawnedRope != null) {
            source.method_9226(() -> class_2561.method_43470((String)String.format("Successfully spawned rope with ID %s at %.2f, %.2f, %.2f", spawnedRope.getPhysicsId().toString().substring(0, 8), pos.method_10216(), pos.method_10214(), pos.method_10215())), true);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Failed to spawn the rope. Check logs for details."));
        return 0;
    }
}

