/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.physicsgun.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.xmx.velthoric.item.physicsgun.manager.PhysicsGunServerManager;

public class PhysicsGunActionPacket {
    private final ActionType actionType;
    private final float value1;
    private final float value2;

    public PhysicsGunActionPacket(ActionType actionType) {
        this(actionType, 0.0f, 0.0f);
    }

    public PhysicsGunActionPacket(float scrollDelta) {
        this(ActionType.UPDATE_SCROLL, scrollDelta, 0.0f);
    }

    public PhysicsGunActionPacket(float deltaX, float deltaY) {
        this(ActionType.UPDATE_ROTATION, deltaX, deltaY);
    }

    private PhysicsGunActionPacket(ActionType actionType, float value1, float value2) {
        this.actionType = actionType;
        this.value1 = value1;
        this.value2 = value2;
    }

    public static void encode(PhysicsGunActionPacket msg, class_2540 buf) {
        buf.method_10817((Enum)msg.actionType);
        if (msg.actionType == ActionType.UPDATE_SCROLL) {
            buf.writeFloat(msg.value1);
        } else if (msg.actionType == ActionType.UPDATE_ROTATION) {
            buf.writeFloat(msg.value1);
            buf.writeFloat(msg.value2);
        }
    }

    public static PhysicsGunActionPacket decode(class_2540 buf) {
        ActionType actionType = (ActionType)buf.method_10818(ActionType.class);
        float value1 = 0.0f;
        float value2 = 0.0f;
        if (actionType == ActionType.UPDATE_SCROLL) {
            value1 = buf.readFloat();
        } else if (actionType == ActionType.UPDATE_ROTATION) {
            value1 = buf.readFloat();
            value2 = buf.readFloat();
        }
        return new PhysicsGunActionPacket(actionType, value1, value2);
    }

    public static void handle(PhysicsGunActionPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            class_3222 player = (class_3222)context.getPlayer();
            if (player == null) {
                return;
            }
            PhysicsGunServerManager manager = PhysicsGunServerManager.getInstance();
            switch (msg.actionType) {
                case START_GRAB_ATTEMPT: {
                    manager.startGrabAttempt(player);
                    break;
                }
                case STOP_GRAB_ATTEMPT: {
                    manager.stopGrabAttempt(player);
                    break;
                }
                case UPDATE_SCROLL: {
                    manager.updateScroll(player, msg.value1);
                    break;
                }
                case UPDATE_ROTATION: {
                    manager.updateRotation(player, msg.value1, msg.value2);
                    break;
                }
                case FREEZE_OBJECT: {
                    manager.freezeObject(player);
                    break;
                }
                case START_ROTATION_MODE: {
                    manager.startRotationMode(player);
                    break;
                }
                case STOP_ROTATION_MODE: {
                    manager.stopRotationMode(player);
                }
            }
        });
    }

    public static enum ActionType {
        START_GRAB_ATTEMPT,
        STOP_GRAB_ATTEMPT,
        UPDATE_SCROLL,
        UPDATE_ROTATION,
        FREEZE_OBJECT,
        START_ROTATION_MODE,
        STOP_ROTATION_MODE;

    }
}

