/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.math;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import net.minecraft.class_3532;

public class VxOperations {
    public static RVec3 lerp(RVec3Arg v1, RVec3Arg v2, float alpha, RVec3 store) {
        if (store == null) {
            store = new RVec3();
        }
        double x = class_3532.method_16436((double)alpha, (double)v1.xx(), (double)v2.xx());
        double y = class_3532.method_16436((double)alpha, (double)v1.yy(), (double)v2.yy());
        double z = class_3532.method_16436((double)alpha, (double)v1.zz(), (double)v2.zz());
        store.set(x, y, z);
        return store;
    }

    public static Quat slerp(QuatArg q1, QuatArg q2, float alpha, Quat store) {
        if (store == null) {
            store = new Quat();
        }
        double dot = q1.getX() * q2.getX() + q1.getY() * q2.getY() + q1.getZ() * q2.getZ() + q1.getW() * q2.getW();
        Quat q2b = new Quat(q2);
        if (dot < 0.0) {
            dot = -dot;
            q2b.set(-q2b.getX(), -q2b.getY(), -q2b.getZ(), -q2b.getW());
        }
        if (dot > (double)0.9995f) {
            float resX = class_3532.method_16439((float)alpha, (float)q1.getX(), (float)q2b.getX());
            float resY = class_3532.method_16439((float)alpha, (float)q1.getY(), (float)q2b.getY());
            float resZ = class_3532.method_16439((float)alpha, (float)q1.getZ(), (float)q2b.getZ());
            float resW = class_3532.method_16439((float)alpha, (float)q1.getW(), (float)q2b.getW());
            store.set(resX, resY, resZ, resW);
            store.set(store.normalized());
            return store;
        }
        double theta0 = Math.acos(dot);
        double sinTheta0 = Math.sin(theta0);
        double scale0 = Math.sin((1.0 - (double)alpha) * theta0) / sinTheta0;
        double scale1 = Math.sin((double)alpha * theta0) / sinTheta0;
        float resX = (float)(scale0 * (double)q1.getX() + scale1 * (double)q2b.getX());
        float resY = (float)(scale0 * (double)q1.getY() + scale1 * (double)q2b.getY());
        float resZ = (float)(scale0 * (double)q1.getZ() + scale1 * (double)q2b.getZ());
        float resW = (float)(scale0 * (double)q1.getW() + scale1 * (double)q2b.getW());
        store.set(resX, resY, resZ, resW);
        return store;
    }

    public static void extrapolateRotation(QuatArg startRot, Vec3Arg angVel, float dt, Quat out) {
        float angle = angVel.length() * dt;
        if (angle > 1.0E-6f) {
            Vec3 axis = angVel.normalized();
            Quat deltaRot = Quat.sRotation(axis, angle);
            Quat finalRot = Op.star((QuatArg)deltaRot, startRot);
            out.set(finalRot.normalized());
        } else {
            out.set(startRot);
        }
    }

    public static RVec3 extrapolatePosition(RVec3Arg p0, Vec3Arg v0, float dt, RVec3 store) {
        if (store == null) {
            store = new RVec3();
        }
        store.set(p0.xx() + (double)v0.getX() * (double)dt, p0.yy() + (double)v0.getY() * (double)dt, p0.zz() + (double)v0.getZ() * (double)dt);
        return store;
    }

    public static Quat interpolateCubic(QuatArg q0, Vec3Arg angVel0, QuatArg q1, Vec3Arg angVel1, float dt, float t, Quat store) {
        if (store == null) {
            store = new Quat();
        }
        Quat c0 = new Quat();
        VxOperations.extrapolateRotation(q0, angVel0, dt / 3.0f, c0);
        Quat c1 = new Quat();
        Vec3 invertedAngVel1 = Op.minus(angVel1);
        VxOperations.extrapolateRotation(q1, invertedAngVel1, dt / 3.0f, c1);
        Quat tempA = new Quat();
        Quat tempB = new Quat();
        VxOperations.slerp(q0, c0, t, tempA);
        VxOperations.slerp(c0, c1, t, tempB);
        VxOperations.slerp(c1, q1, t, store);
        VxOperations.slerp(tempA, tempB, t, tempA);
        VxOperations.slerp(tempB, store, t, tempB);
        VxOperations.slerp(tempA, tempB, t, store);
        store.set(store.normalized());
        return store;
    }

    public static RVec3 cubicHermite(RVec3Arg p0, Vec3 v0, RVec3Arg p1, Vec3 v1, float t, float dt, RVec3 store) {
        if (store == null) {
            store = new RVec3();
        }
        float t2 = t * t;
        float t3 = t2 * t;
        float h1 = 2.0f * t3 - 3.0f * t2 + 1.0f;
        float h2 = -2.0f * t3 + 3.0f * t2;
        float h3 = t3 - 2.0f * t2 + t;
        float h4 = t3 - t2;
        double x = (double)h1 * p0.xx() + (double)h2 * p1.xx() + (double)(h3 * (v0.getX() * dt)) + (double)(h4 * (v1.getX() * dt));
        double y = (double)h1 * p0.yy() + (double)h2 * p1.yy() + (double)(h3 * (v0.getY() * dt)) + (double)(h4 * (v1.getY() * dt));
        double z = (double)h1 * p0.zz() + (double)h2 * p1.zz() + (double)(h3 * (v0.getZ() * dt)) + (double)(h4 * (v1.getZ() * dt));
        store.set(x, y, z);
        return store;
    }

    public static Vec3 quatToEulerAngles(QuatArg q) {
        Vec3 angles = new Vec3();
        double sinr_cosp = 2.0 * (double)(q.getW() * q.getX() + q.getY() * q.getZ());
        double cosr_cosp = 1.0 - 2.0 * (double)(q.getX() * q.getX() + q.getY() * q.getY());
        angles.setX((float)Math.atan2(sinr_cosp, cosr_cosp));
        double sinp = 2.0 * (double)(q.getW() * q.getY() - q.getZ() * q.getX());
        if (Math.abs(sinp) >= 1.0) {
            angles.setY((float)Math.copySign(1.5707963267948966, sinp));
        } else {
            angles.setY((float)Math.asin(sinp));
        }
        double siny_cosp = 2.0 * (double)(q.getW() * q.getZ() + q.getX() * q.getY());
        double cosy_cosp = 1.0 - 2.0 * (double)(q.getY() * q.getY() + q.getZ() * q.getZ());
        angles.setZ((float)Math.atan2(siny_cosp, cosy_cosp));
        return angles;
    }
}

