/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.riding.render;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.xmx.velthoric.physics.object.client.VxClientObjectDataStore;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.riding.VxOriginalState;
import net.xmx.velthoric.physics.riding.VxRidingProxyEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_757.class})
public abstract class MixinGameRenderer_SmoothEntityPosition {
    @Shadow
    @Final
    class_310 field_4015;
    @Unique
    private final RVec3 velthoric_interpolatedPosition = new RVec3();
    @Unique
    private final Quat velthoric_interpolatedRotation = new Quat();
    @Unique
    private final Map<Integer, VxOriginalState> velthoric_originalStates = new HashMap<Integer, VxOriginalState>();

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V", shift=At.Shift.BEFORE)})
    private void velthoric_preRenderLevel(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        class_638 clientWorld = this.field_4015.field_1687;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.clear();
        for (class_1297 entity : clientWorld.method_18112()) {
            class_1297 passenger;
            VxRidingProxyEntity proxy;
            if (!(entity instanceof VxRidingProxyEntity) || (proxy = (VxRidingProxyEntity)entity).method_5685().isEmpty() || (passenger = proxy.method_31483()) == null) continue;
            this.velthoric_adjustEntityForRender(proxy, tickDelta);
            this.velthoric_adjustEntityForRender(passenger, tickDelta);
        }
    }

    @Unique
    private void velthoric_adjustEntityForRender(class_1297 entity, float tickDelta) {
        VxRidingProxyEntity proxy;
        class_1297 vehicle = entity.method_5854();
        if (vehicle instanceof VxRidingProxyEntity) {
            VxRidingProxyEntity vehicleProxy;
            proxy = vehicleProxy = (VxRidingProxyEntity)vehicle;
        } else if (entity instanceof VxRidingProxyEntity) {
            VxRidingProxyEntity selfProxy;
            proxy = selfProxy = (VxRidingProxyEntity)entity;
        } else {
            return;
        }
        VxRidingProxyEntity finalProxy = proxy;
        finalProxy.getPhysicsObjectId().ifPresent(id -> {
            VxClientObjectManager manager = VxClientObjectManager.getInstance();
            VxClientObjectDataStore store = manager.getStore();
            Integer index = store.getIndexForId((UUID)id);
            if (index == null || !store.render_isInitialized[index]) {
                return;
            }
            this.velthoric_originalStates.computeIfAbsent(entity.method_5628(), k -> new VxOriginalState()).setFrom(entity);
            manager.getInterpolator().interpolateFrame(store, index, tickDelta, this.velthoric_interpolatedPosition, this.velthoric_interpolatedRotation);
            Quaternionf physRotation = new Quaternionf(this.velthoric_interpolatedRotation.getX(), this.velthoric_interpolatedRotation.getY(), this.velthoric_interpolatedRotation.getZ(), this.velthoric_interpolatedRotation.getW());
            Vector3f rideOffset = new Vector3f((Vector3fc)finalProxy.getRidePositionOffset());
            physRotation.transform(rideOffset);
            double targetX = this.velthoric_interpolatedPosition.xx() + (double)rideOffset.x;
            double targetY = this.velthoric_interpolatedPosition.yy() + (double)rideOffset.y;
            double targetZ = this.velthoric_interpolatedPosition.zz() + (double)rideOffset.z;
            entity.method_5814(targetX, targetY, targetZ);
            entity.field_6014 = targetX;
            entity.field_6036 = targetY;
            entity.field_5969 = targetZ;
            entity.field_6038 = targetX;
            entity.field_5971 = targetY;
            entity.field_5989 = targetZ;
        });
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V", shift=At.Shift.AFTER)})
    private void velthoric_postRenderLevel(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        class_638 clientWorld = this.field_4015.field_1687;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.forEach((id, state) -> {
            class_1297 entity = clientWorld.method_8469(id.intValue());
            if (entity != null) {
                state.applyTo(entity);
            }
        });
        this.velthoric_originalStates.clear();
    }
}

