/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.riding.render.bounds;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_757;
import net.xmx.velthoric.math.VxOBB;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.body.VxClientBody;
import net.xmx.velthoric.physics.riding.VxRidingProxyEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_757.class})
public abstract class MixinGameRenderer_TranformPick {
    @Shadow
    @Final
    private class_310 field_4015;

    @WrapOperation(method={"pick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;")})
    private class_3966 velthoric_pickEntityWithOBB(class_1297 shooter, class_243 start, class_243 end, class_238 searchBox, Predicate<class_1297> filter, double maxDistanceSq, Operation<class_3966> original) {
        Predicate<class_1297> vanillaFilter = filter.and(entity -> !(entity.method_5854() instanceof VxRidingProxyEntity));
        class_3966 vanillaResult = (class_3966)original.call(new Object[]{shooter, start, end, searchBox, vanillaFilter, maxDistanceSq});
        double closestHitDistSq = vanillaResult != null ? start.method_1025(vanillaResult.method_17784()) : maxDistanceSq;
        class_3966 bestOverallResult = vanillaResult;
        List potentialTargets = this.field_4015.field_1687.method_8333(shooter, searchBox, filter);
        float partialTicks = this.field_4015.method_1488();
        for (class_1297 potentialTarget : potentialTargets) {
            double distSq;
            VxRidingProxyEntity proxy;
            Optional physObjectOpt;
            class_1297 class_12972 = potentialTarget.method_5854();
            if (!(class_12972 instanceof VxRidingProxyEntity) || !(physObjectOpt = (proxy = (VxRidingProxyEntity)class_12972).getPhysicsObjectId().flatMap(id -> Optional.ofNullable(VxClientObjectManager.getInstance().getObject((UUID)id)))).isPresent() || !((VxClientBody)physObjectOpt.get()).isInitialized()) continue;
            VxClientBody physObject = (VxClientBody)physObjectOpt.get();
            VxTransform physTransform = this.velthoric_getPhysicsObjectTransform(physObject, partialTicks);
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getRidePositionOffset());
            physTransform.getRotation(new Quaternionf()).transform(rideOffset);
            physTransform.getTranslation().addInPlace(rideOffset.x(), rideOffset.y(), rideOffset.z());
            class_238 targetAABB = potentialTarget.method_5829().method_1014((double)potentialTarget.method_5871());
            class_238 localEntityAABB = targetAABB.method_989(-potentialTarget.method_23317(), -potentialTarget.method_23318(), -potentialTarget.method_23321());
            VxOBB obb = new VxOBB(physTransform, localEntityAABB);
            Optional<class_243> hitPos = obb.clip(start, end);
            if (!hitPos.isPresent() || !((distSq = start.method_1025(hitPos.get())) < closestHitDistSq)) continue;
            closestHitDistSq = distSq;
            bestOverallResult = new class_3966(potentialTarget, hitPos.get());
        }
        return bestOverallResult;
    }

    @Unique
    private VxTransform velthoric_getPhysicsObjectTransform(VxClientBody clientBody, float partialTicks) {
        VxTransform transform = new VxTransform();
        RVec3 pos = new RVec3();
        Quat rot = new Quat();
        VxClientObjectManager.getInstance().getInterpolator().interpolateFrame(VxClientObjectManager.getInstance().getStore(), clientBody.getDataStoreIndex(), partialTicks, pos, rot);
        transform.getTranslation().set(pos);
        transform.getRotation().set(rot);
        return transform;
    }
}

