/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.natives;

import com.github.stephengold.joltjni.BroadPhaseLayerInterface;
import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.ObjectLayerPairFilter;
import com.github.stephengold.joltjni.ObjectVsBroadPhaseLayerFilter;
import dev.architectury.platform.Platform;
import java.nio.file.Path;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.natives.VxLayers;
import net.xmx.vxnative.VxNativeLibraryLoader;

public class VxNativeJolt {
    private static volatile boolean isInitialized = false;

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        VxMainClass.LOGGER.debug("Performing Physics initialization...");
        Path extractionPath = Platform.getGameFolder().resolve("velthoric").resolve("natives");
        VxNativeLibraryLoader.load(extractionPath);
        Jolt.registerDefaultAllocator();
        Jolt.installDefaultAssertCallback();
        Jolt.installDefaultTraceCallback();
        JoltPhysicsObject.startCleaner();
        if (!Jolt.newFactory()) {
            throw new IllegalStateException("Jolt Factory could not be created.");
        }
        Jolt.registerTypes();
        VxLayers.initialize();
        isInitialized = true;
        VxMainClass.LOGGER.debug("Physics initialization complete.");
    }

    public static void shutdown() {
        if (!isInitialized) {
            return;
        }
        VxMainClass.LOGGER.debug("Performing Physics shutdown...");
        VxLayers.shutdown();
        Jolt.destroyFactory();
        isInitialized = false;
        VxMainClass.LOGGER.debug("Physics shutdown complete.");
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static BroadPhaseLayerInterface getBroadPhaseLayerInterface() {
        return VxLayers.getBroadPhaseLayerInterface();
    }

    public static ObjectVsBroadPhaseLayerFilter getObjectVsBroadPhaseLayerFilter() {
        return VxLayers.getObjectVsBroadPhaseLayerFilter();
    }

    public static ObjectLayerPairFilter getObjectLayerPairFilter() {
        return VxLayers.getObjectLayerPairFilter();
    }
}

