/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics;

import dev.architectury.event.events.common.TickEvent;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.xmx.velthoric.event.api.VxLevelEvent;
import net.xmx.velthoric.event.api.VxServerLifecycleEvent;
import net.xmx.velthoric.physics.persistence.VxPersistenceManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxLifecycleEvents {
    public static void registerEvents() {
        VxServerLifecycleEvent.Starting.EVENT.register(VxLifecycleEvents::onServerStarting);
        VxLevelEvent.Load.EVENT.register(VxLifecycleEvents::onLevelLoad);
        VxLevelEvent.Unload.EVENT.register(VxLifecycleEvents::onLevelUnload);
        VxServerLifecycleEvent.Stopping.EVENT.register(VxLifecycleEvents::onServerStopping);
        TickEvent.SERVER_LEVEL_PRE.register(VxLifecycleEvents::onLevelTick);
    }

    private static void onServerStarting(VxServerLifecycleEvent.Starting event) {
        VxPersistenceManager.initialize();
    }

    private static void onServerStopping(VxServerLifecycleEvent.Stopping event) {
        VxPhysicsWorld.shutdownAll();
        VxPersistenceManager.shutdown();
    }

    private static void onLevelLoad(VxLevelEvent.Load event) {
        class_3218 level = event.getLevel();
        if (!level.method_8608()) {
            VxPhysicsWorld.getOrCreate(level);
        }
    }

    private static void onLevelUnload(VxLevelEvent.Unload event) {
        class_3218 level = event.getLevel();
        if (!level.method_8608()) {
            VxPhysicsWorld.shutdown((class_5321<class_1937>)level.method_27983());
        }
    }

    private static void onLevelTick(class_3218 level) {
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)level.method_27983());
        if (physicsWorld != null && physicsWorld.isRunning()) {
            physicsWorld.onGameTick(level);
        }
    }
}

