/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.constraint.manager;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.xmx.velthoric.physics.constraint.VxConstraint;
import net.xmx.velthoric.physics.constraint.manager.VxConstraintManager;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.object.type.VxBody;

public class DependencyDataSystem {
    private final VxConstraintManager constraintManager;
    private final Map<UUID, VxConstraint> pendingConstraints = new ConcurrentHashMap<UUID, VxConstraint>();
    private final Map<UUID, Set<UUID>> bodyToConstraintMap = new ConcurrentHashMap<UUID, Set<UUID>>();

    public DependencyDataSystem(VxConstraintManager constraintManager) {
        this.constraintManager = constraintManager;
    }

    public void addPendingConstraint(VxConstraint constraint) {
        UUID constraintId = constraint.getConstraintId();
        this.pendingConstraints.put(constraintId, constraint);
        this.bodyToConstraintMap.computeIfAbsent(constraint.getBody1Id(), k -> ConcurrentHashMap.newKeySet()).add(constraintId);
        this.bodyToConstraintMap.computeIfAbsent(constraint.getBody2Id(), k -> ConcurrentHashMap.newKeySet()).add(constraintId);
        this.onDependencyLoaded(constraint.getBody1Id());
        this.onDependencyLoaded(constraint.getBody2Id());
    }

    public void onDependencyLoaded(UUID bodyId) {
        Set<UUID> affectedConstraints = this.bodyToConstraintMap.get(bodyId);
        if (affectedConstraints == null || affectedConstraints.isEmpty()) {
            return;
        }
        for (UUID constraintId : Set.copyOf(affectedConstraints)) {
            boolean body2Ready;
            VxConstraint constraint = this.pendingConstraints.get(constraintId);
            if (constraint == null) {
                this.cleanup(constraintId);
                continue;
            }
            VxObjectManager objectManager = this.constraintManager.getObjectManager();
            VxBody body1 = objectManager.getObject(constraint.getBody1Id());
            VxBody body2 = objectManager.getObject(constraint.getBody2Id());
            boolean body1Ready = body1 != null && body1.getBodyId() != 0;
            boolean bl = body2Ready = body2 != null && body2.getBodyId() != 0;
            if (!body1Ready || !body2Ready || this.pendingConstraints.remove(constraintId) == null) continue;
            this.cleanup(constraintId);
            this.constraintManager.activateConstraint(constraint);
        }
    }

    public void removeForBody(UUID bodyId) {
        Set<UUID> affectedConstraints = this.bodyToConstraintMap.remove(bodyId);
        if (affectedConstraints != null) {
            for (UUID constraintId : Set.copyOf(affectedConstraints)) {
                this.pendingConstraints.remove(constraintId);
                this.cleanup(constraintId);
            }
        }
    }

    public boolean isPending(UUID constraintId) {
        return this.pendingConstraints.containsKey(constraintId);
    }

    private void cleanup(UUID constraintId) {
        this.bodyToConstraintMap.values().forEach(set -> set.remove(constraintId));
    }

    public void clear() {
        this.pendingConstraints.clear();
        this.bodyToConstraintMap.clear();
    }
}

