/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.constraint.manager;

import com.github.stephengold.joltjni.ConeConstraintSettings;
import com.github.stephengold.joltjni.ConstraintSettings;
import com.github.stephengold.joltjni.ConstraintSettingsRef;
import com.github.stephengold.joltjni.DistanceConstraintSettings;
import com.github.stephengold.joltjni.FixedConstraintSettings;
import com.github.stephengold.joltjni.GearConstraintSettings;
import com.github.stephengold.joltjni.HingeConstraintSettings;
import com.github.stephengold.joltjni.PointConstraintSettings;
import com.github.stephengold.joltjni.PulleyConstraintSettings;
import com.github.stephengold.joltjni.RackAndPinionConstraintSettings;
import com.github.stephengold.joltjni.SixDofConstraintSettings;
import com.github.stephengold.joltjni.SliderConstraintSettings;
import com.github.stephengold.joltjni.SwingTwistConstraintSettings;
import com.github.stephengold.joltjni.TwoBodyConstraint;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.constraint.VxConstraint;
import net.xmx.velthoric.physics.constraint.manager.DependencyDataSystem;
import net.xmx.velthoric.physics.constraint.persistence.VxConstraintStorage;
import net.xmx.velthoric.physics.constraint.serializer.ConstraintSerializerRegistry;
import net.xmx.velthoric.physics.constraint.serializer.IVxConstraintSerializer;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public class VxConstraintManager {
    private final VxPhysicsWorld world;
    private final VxObjectManager objectManager;
    private final VxConstraintStorage constraintStorage;
    private final DependencyDataSystem dataSystem;
    private final Map<UUID, VxConstraint> activeConstraints = new ConcurrentHashMap<UUID, VxConstraint>();

    public VxConstraintManager(VxObjectManager objectManager) {
        this.objectManager = objectManager;
        this.world = objectManager.getPhysicsWorld();
        this.constraintStorage = new VxConstraintStorage(this.world.getLevel(), this);
        this.dataSystem = new DependencyDataSystem(this);
        ConstraintSerializerRegistry.initialize();
    }

    public void initialize(VxPhysicsWorld world) {
        this.constraintStorage.initialize();
    }

    public void saveData() {
        this.activeConstraints.values().forEach(this.constraintStorage::storeConstraint);
        this.constraintStorage.saveDirtyRegions();
    }

    public void shutdown() {
        this.saveData();
        this.activeConstraints.clear();
        this.dataSystem.clear();
        this.constraintStorage.shutdown();
    }

    @Nullable
    public VxConstraint createConstraint(TwoBodyConstraintSettings settings, UUID body1Id, UUID body2Id) {
        if (settings == null || body1Id == null || body2Id == null) {
            return null;
        }
        UUID constraintId = UUID.randomUUID();
        VxConstraint constraint = new VxConstraint(constraintId, body1Id, body2Id, settings);
        this.dataSystem.addPendingConstraint(constraint);
        return constraint;
    }

    public void addConstraintFromStorage(VxConstraint constraint) {
        this.dataSystem.addPendingConstraint(constraint);
    }

    protected void activateConstraint(VxConstraint constraint) {
        this.world.execute(() -> {
            VxBody body1 = this.objectManager.getObject(constraint.getBody1Id());
            VxBody body2 = this.objectManager.getObject(constraint.getBody2Id());
            if (body1 == null || body2 == null || body1.getBodyId() == 0 || body2.getBodyId() == 0) {
                this.dataSystem.addPendingConstraint(constraint);
                return;
            }
            Optional<IVxConstraintSerializer<?>> rawSerializerOpt = ConstraintSerializerRegistry.get(constraint.getSubType());
            if (rawSerializerOpt.isEmpty()) {
                VxMainClass.LOGGER.error("No serializer found for constraint type {} (ID: {})", (Object)constraint.getSubType(), (Object)constraint.getConstraintId());
                return;
            }
            IVxConstraintSerializer<?> serializer = rawSerializerOpt.get();
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])constraint.getSettingsData());
            Object loadedSettings = serializer.load(buffer);
            try (Object obj = loadedSettings;){
                buffer.release();
                boolean wasCreatedWithWorldSpace = VxConstraintManager.isCreatedWithWorldSpace(loadedSettings);
                TwoBodyConstraint joltConstraint = this.world.getBodyInterface().createConstraint((TwoBodyConstraintSettings)loadedSettings, body1.getBodyId(), body2.getBodyId());
                if (joltConstraint == null) {
                    VxMainClass.LOGGER.error("Failed to create Jolt constraint for {}", (Object)constraint.getConstraintId());
                    return;
                }
                if (wasCreatedWithWorldSpace) {
                    try (ConstraintSettingsRef settingsRef = joltConstraint.getConstraintSettings();
                         ConstraintSettings canonicalSettingsRaw = settingsRef.getPtr();){
                        if (canonicalSettingsRaw instanceof TwoBodyConstraintSettings) {
                            TwoBodyConstraintSettings canonicalSettings = (TwoBodyConstraintSettings)canonicalSettingsRaw;
                            constraint.updateSettingsData(canonicalSettings);
                        }
                    }
                }
                this.world.getPhysicsSystem().addConstraint(joltConstraint);
                constraint.setJoltConstraint(joltConstraint);
                this.activeConstraints.put(constraint.getConstraintId(), constraint);
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Exception during constraint activation for {}", (Object)constraint.getConstraintId(), (Object)e);
            }
        });
    }

    private static boolean isCreatedWithWorldSpace(TwoBodyConstraintSettings loadedSettings) {
        boolean wasCreatedWithWorldSpace = false;
        if (loadedSettings instanceof ConeConstraintSettings) {
            ConeConstraintSettings s = (ConeConstraintSettings)loadedSettings;
            wasCreatedWithWorldSpace = s.getSpace() == EConstraintSpace.WorldSpace;
        } else if (loadedSettings instanceof DistanceConstraintSettings) {
            DistanceConstraintSettings s = (DistanceConstraintSettings)loadedSettings;
            wasCreatedWithWorldSpace = s.getSpace() == EConstraintSpace.WorldSpace;
        } else if (loadedSettings instanceof FixedConstraintSettings) {
            FixedConstraintSettings s = (FixedConstraintSettings)loadedSettings;
            wasCreatedWithWorldSpace = s.getSpace() == EConstraintSpace.WorldSpace;
        } else if (loadedSettings instanceof GearConstraintSettings) {
            GearConstraintSettings s = (GearConstraintSettings)loadedSettings;
            wasCreatedWithWorldSpace = s.getSpace() == EConstraintSpace.WorldSpace;
        } else if (loadedSettings instanceof HingeConstraintSettings) {
            HingeConstraintSettings s = (HingeConstraintSettings)loadedSettings;
            wasCreatedWithWorldSpace = s.getSpace() == EConstraintSpace.WorldSpace;
        } else if (loadedSettings instanceof PointConstraintSettings) {
            PointConstraintSettings s = (PointConstraintSettings)loadedSettings;
            wasCreatedWithWorldSpace = s.getSpace() == EConstraintSpace.WorldSpace;
        } else if (loadedSettings instanceof PulleyConstraintSettings) {
            PulleyConstraintSettings s = (PulleyConstraintSettings)loadedSettings;
            wasCreatedWithWorldSpace = s.getSpace() == EConstraintSpace.WorldSpace;
        } else if (loadedSettings instanceof RackAndPinionConstraintSettings) {
            RackAndPinionConstraintSettings s = (RackAndPinionConstraintSettings)loadedSettings;
            wasCreatedWithWorldSpace = s.getSpace() == EConstraintSpace.WorldSpace;
        } else if (loadedSettings instanceof SixDofConstraintSettings) {
            SixDofConstraintSettings s = (SixDofConstraintSettings)loadedSettings;
            wasCreatedWithWorldSpace = s.getSpace() == EConstraintSpace.WorldSpace;
        } else if (loadedSettings instanceof SliderConstraintSettings) {
            SliderConstraintSettings s = (SliderConstraintSettings)loadedSettings;
            wasCreatedWithWorldSpace = s.getSpace() == EConstraintSpace.WorldSpace;
        } else if (loadedSettings instanceof SwingTwistConstraintSettings) {
            SwingTwistConstraintSettings s = (SwingTwistConstraintSettings)loadedSettings;
            wasCreatedWithWorldSpace = s.getSpace() == EConstraintSpace.WorldSpace;
        }
        return wasCreatedWithWorldSpace;
    }

    public void removeConstraint(UUID constraintId, boolean discardData) {
        VxConstraint constraint = this.activeConstraints.remove(constraintId);
        if (constraint != null && constraint.getJoltConstraint() != null) {
            this.world.execute(() -> {
                this.world.getPhysicsSystem().removeConstraint(constraint.getJoltConstraint());
                constraint.getJoltConstraint().close();
            });
        }
        if (discardData) {
            this.constraintStorage.removeData(constraintId);
        }
    }

    public void removeConstraintsForObject(UUID bodyId, boolean discardData) {
        this.activeConstraints.values().stream().filter(c -> c.getBody1Id().equals(bodyId) || c.getBody2Id().equals(bodyId)).forEach(c -> this.removeConstraint(c.getConstraintId(), discardData));
        this.dataSystem.removeForBody(bodyId);
    }

    public boolean hasActiveConstraint(UUID id) {
        return this.activeConstraints.containsKey(id);
    }

    public VxConstraintStorage getConstraintStorage() {
        return this.constraintStorage;
    }

    public VxObjectManager getObjectManager() {
        return this.objectManager;
    }

    public VxPhysicsWorld getWorld() {
        return this.world;
    }

    public DependencyDataSystem getDataSystem() {
        return this.dataSystem;
    }
}

