/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.constraint.manager.event;

import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.xmx.velthoric.event.api.VxChunkEvent;
import net.xmx.velthoric.event.api.VxLevelEvent;
import net.xmx.velthoric.physics.constraint.manager.VxConstraintManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class ConstraintLifecycleEvents {
    public static void registerEvents() {
        VxChunkEvent.Load.EVENT.register(ConstraintLifecycleEvents::onChunkLoad);
        VxLevelEvent.Save.EVENT.register(ConstraintLifecycleEvents::onLevelSave);
    }

    private static Optional<VxConstraintManager> getConstraintManager(class_1937 level) {
        if (level.method_8608()) {
            return Optional.empty();
        }
        VxPhysicsWorld world = VxPhysicsWorld.get((class_5321<class_1937>)level.method_27983());
        if (world != null && world.getConstraintManager() != null) {
            return Optional.of(world.getConstraintManager());
        }
        return Optional.empty();
    }

    private static void onChunkLoad(VxChunkEvent.Load event) {
        ConstraintLifecycleEvents.getConstraintManager((class_1937)event.getLevel()).ifPresent(manager -> manager.getConstraintStorage().loadConstraintsInChunk(event.getChunkPos()));
    }

    private static void onLevelSave(VxLevelEvent.Save event) {
        ConstraintLifecycleEvents.getConstraintManager((class_1937)event.getLevel()).ifPresent(VxConstraintManager::saveData);
    }
}

