/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.constraint.serializer;

import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.xmx.velthoric.physics.constraint.serializer.IVxConstraintSerializer;
import net.xmx.velthoric.physics.constraint.serializer.type.ConeConstraintSerializer;
import net.xmx.velthoric.physics.constraint.serializer.type.DistanceConstraintSerializer;
import net.xmx.velthoric.physics.constraint.serializer.type.FixedConstraintSerializer;
import net.xmx.velthoric.physics.constraint.serializer.type.GearConstraintSerializer;
import net.xmx.velthoric.physics.constraint.serializer.type.HingeConstraintSerializer;
import net.xmx.velthoric.physics.constraint.serializer.type.PathConstraintSerializer;
import net.xmx.velthoric.physics.constraint.serializer.type.PointConstraintSerializer;
import net.xmx.velthoric.physics.constraint.serializer.type.PulleyConstraintSerializer;
import net.xmx.velthoric.physics.constraint.serializer.type.RackAndPinionConstraintSerializer;
import net.xmx.velthoric.physics.constraint.serializer.type.SixDofConstraintSerializer;
import net.xmx.velthoric.physics.constraint.serializer.type.SliderConstraintSerializer;
import net.xmx.velthoric.physics.constraint.serializer.type.SwingTwistConstraintSerializer;

public final class ConstraintSerializerRegistry {
    private static final Map<EConstraintSubType, IVxConstraintSerializer<?>> serializers = new EnumMap(EConstraintSubType.class);

    public static void initialize() {
        ConstraintSerializerRegistry.register(EConstraintSubType.Hinge, new HingeConstraintSerializer());
        ConstraintSerializerRegistry.register(EConstraintSubType.SixDof, new SixDofConstraintSerializer());
        ConstraintSerializerRegistry.register(EConstraintSubType.Cone, new ConeConstraintSerializer());
        ConstraintSerializerRegistry.register(EConstraintSubType.Distance, new DistanceConstraintSerializer());
        ConstraintSerializerRegistry.register(EConstraintSubType.Fixed, new FixedConstraintSerializer());
        ConstraintSerializerRegistry.register(EConstraintSubType.Gear, new GearConstraintSerializer());
        ConstraintSerializerRegistry.register(EConstraintSubType.Path, new PathConstraintSerializer());
        ConstraintSerializerRegistry.register(EConstraintSubType.Point, new PointConstraintSerializer());
        ConstraintSerializerRegistry.register(EConstraintSubType.Pulley, new PulleyConstraintSerializer());
        ConstraintSerializerRegistry.register(EConstraintSubType.RackAndPinion, new RackAndPinionConstraintSerializer());
        ConstraintSerializerRegistry.register(EConstraintSubType.Slider, new SliderConstraintSerializer());
        ConstraintSerializerRegistry.register(EConstraintSubType.SwingTwist, new SwingTwistConstraintSerializer());
    }

    private static <T extends TwoBodyConstraintSettings> void register(EConstraintSubType type, IVxConstraintSerializer<T> serializer) {
        serializers.put(type, serializer);
    }

    public static Optional<IVxConstraintSerializer<?>> get(EConstraintSubType type) {
        return Optional.ofNullable(serializers.get((Object)type));
    }
}

