/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.constraint.serializer;

import com.github.stephengold.joltjni.MotorSettings;
import com.github.stephengold.joltjni.PathConstraintPath;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.SpringSettings;
import com.github.stephengold.joltjni.StreamOutWrapper;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstPathConstraintPath;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.std.StringStream;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public final class ConstraintSerializerUtils {
    private ConstraintSerializerUtils() {
    }

    public static void saveVec3(Vec3Arg vec, ByteBuf buf) {
        buf.writeFloat(vec.getX());
        buf.writeFloat(vec.getY());
        buf.writeFloat(vec.getZ());
    }

    public static Vec3 loadVec3(ByteBuf buf) {
        return new Vec3(buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public static void saveRVec3(RVec3Arg vec, ByteBuf buf) {
        buf.writeDouble(vec.xx());
        buf.writeDouble(vec.yy());
        buf.writeDouble(vec.zz());
    }

    public static RVec3 loadRVec3(ByteBuf buf) {
        return new RVec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void saveSpring(SpringSettings spring, ByteBuf buf) {
        buf.writeFloat(spring.getFrequency());
        buf.writeFloat(spring.getDamping());
    }

    public static void loadSpring(SpringSettings spring, ByteBuf buf) {
        spring.setFrequency(buf.readFloat());
        spring.setDamping(buf.readFloat());
    }

    public static void saveMotor(MotorSettings motor, ByteBuf buf) {
        buf.writeBoolean(motor.isValid());
        if (motor.isValid()) {
            buf.writeFloat(motor.getMinForceLimit());
            buf.writeFloat(motor.getMaxForceLimit());
            buf.writeFloat(motor.getMinTorqueLimit());
            buf.writeFloat(motor.getMaxTorqueLimit());
            try (SpringSettings ss = motor.getSpringSettings();){
                ConstraintSerializerUtils.saveSpring(ss, buf);
            }
        }
    }

    public static void loadMotor(MotorSettings motor, ByteBuf buf) {
        if (buf.readBoolean()) {
            motor.setForceLimits(buf.readFloat(), buf.readFloat());
            motor.setTorqueLimits(buf.readFloat(), buf.readFloat());
            try (SpringSettings ss = motor.getSpringSettings();){
                ConstraintSerializerUtils.loadSpring(ss, buf);
            }
        }
    }

    public static void savePath(ConstPathConstraintPath path, ByteBuf buf) {
        try (StringStream stringStream = new StringStream();
             StreamOutWrapper streamOut = new StreamOutWrapper(stringStream);){
            path.saveBinaryState(streamOut);
            byte[] pathData = stringStream.str().getBytes(StandardCharsets.ISO_8859_1);
            buf.writeInt(pathData.length);
            buf.writeBytes(pathData);
        }
    }

    /*
     * Exception decompiling
     */
    public static PathConstraintPath loadPath(ByteBuf buf) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

