/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.client;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import dev.architectury.event.events.client.ClientTickEvent;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.xmx.velthoric.event.api.VxClientPlayerNetworkEvent;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.object.client.VxClientObjectDataStore;
import net.xmx.velthoric.physics.object.client.VxClientObjectInterpolator;
import net.xmx.velthoric.physics.object.client.body.VxClientBody;
import net.xmx.velthoric.physics.object.client.time.VxClientClock;
import net.xmx.velthoric.physics.object.registry.VxObjectRegistry;
import net.xmx.velthoric.physics.riding.manager.VxClientRidingManager;
import org.jetbrains.annotations.Nullable;

public class VxClientObjectManager {
    private static final VxClientObjectManager INSTANCE = new VxClientObjectManager();
    private static final long INTERPOLATION_DELAY_NANOS = 150000000L;
    private final VxClientObjectDataStore store = new VxClientObjectDataStore();
    private final VxClientObjectInterpolator interpolator = new VxClientObjectInterpolator();
    private final VxClientClock clock = VxClientClock.getInstance();
    private final Map<UUID, VxClientBody> managedObjects = new ConcurrentHashMap<UUID, VxClientBody>();
    private long clockOffsetNanos = 0L;
    private boolean isClockOffsetInitialized = false;
    private final List<Long> clockOffsetSamples = new ArrayList<Long>();

    private VxClientObjectManager() {
    }

    public static VxClientObjectManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClockSyncSample(long offsetSample) {
        List<Long> list = this.clockOffsetSamples;
        synchronized (list) {
            this.clockOffsetSamples.add(offsetSample);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeClock() {
        List<Long> list = this.clockOffsetSamples;
        synchronized (list) {
            if (this.clockOffsetSamples.size() < 20) {
                return;
            }
            Collections.sort(this.clockOffsetSamples);
            int trimCount = this.clockOffsetSamples.size() / 4;
            List<Long> trimmedSamples = this.clockOffsetSamples.subList(trimCount, this.clockOffsetSamples.size() - trimCount);
            if (trimmedSamples.isEmpty()) {
                this.clockOffsetSamples.clear();
                return;
            }
            long sum = 0L;
            for (Long sample : trimmedSamples) {
                sum += sample.longValue();
            }
            long averageOffset = sum / (long)trimmedSamples.size();
            this.clockOffsetSamples.clear();
            if (!this.isClockOffsetInitialized) {
                this.clockOffsetNanos = averageOffset;
                this.isClockOffsetInitialized = true;
            } else {
                this.clockOffsetNanos = (long)((double)this.clockOffsetNanos * 0.95 + (double)averageOffset * 0.05);
            }
        }
    }

    public void spawnObject(UUID id, class_2960 typeId, EBodyType objectType, VxByteBuf data, long timestamp) {
        if (this.store.hasObject(id)) {
            VxMainClass.LOGGER.warn("Client received spawn request for already existing object: {}", (Object)id);
            return;
        }
        int index = this.store.addObject(id);
        this.store.objectType[index] = objectType;
        VxClientBody body = VxObjectRegistry.getInstance().createClientBody(typeId, id, this, index, objectType);
        if (body == null) {
            this.store.removeObject(id);
            VxMainClass.LOGGER.error("Could not spawn client object with type ID '{}', factory not found or failed.", (Object)typeId);
            return;
        }
        this.managedObjects.put(id, body);
        VxTransform transform = new VxTransform();
        transform.fromBuffer(data);
        body.getSynchronizedData().readEntries(data);
        VxClientRidingManager.getInstance().addSeatsFromBuffer(id, data);
        this.initializeState(index, transform, timestamp);
    }

    private void initializeState(int index, VxTransform transform, long timestamp) {
        RVec3 pos = transform.getTranslation();
        Quat rot = transform.getRotation();
        this.store.state0_timestamp[index] = timestamp;
        this.store.state1_timestamp[index] = timestamp;
        this.store.state0_posX[index] = this.store.state1_posX[index] = pos.x();
        this.store.state0_posY[index] = this.store.state1_posY[index] = pos.y();
        this.store.state0_posZ[index] = this.store.state1_posZ[index] = pos.z();
        this.store.state0_rotX[index] = this.store.state1_rotX[index] = rot.getX();
        this.store.state0_rotY[index] = this.store.state1_rotY[index] = rot.getY();
        this.store.state0_rotZ[index] = this.store.state1_rotZ[index] = rot.getZ();
        this.store.state0_rotW[index] = this.store.state1_rotW[index] = rot.getW();
        this.store.state1_isActive[index] = true;
        this.store.state0_isActive[index] = true;
        this.store.render_posX[index] = pos.x();
        this.store.render_posY[index] = pos.y();
        this.store.render_posZ[index] = pos.z();
        this.store.render_rotX[index] = rot.getX();
        this.store.render_rotY[index] = rot.getY();
        this.store.render_rotZ[index] = rot.getZ();
        this.store.render_rotW[index] = rot.getW();
        this.store.prev_posX[index] = pos.x();
        this.store.prev_posY[index] = pos.y();
        this.store.prev_posZ[index] = pos.z();
        this.store.prev_rotX[index] = rot.getX();
        this.store.prev_rotY[index] = rot.getY();
        this.store.prev_rotZ[index] = rot.getZ();
        this.store.prev_rotW[index] = rot.getW();
        this.store.render_isInitialized[index] = true;
        if (this.store.lastKnownPosition[index] == null) {
            this.store.lastKnownPosition[index] = new RVec3();
        }
        this.store.lastKnownPosition[index].set(pos);
    }

    public void removeObject(UUID id) {
        this.managedObjects.remove(id);
        this.store.removeObject(id);
        VxClientRidingManager.getInstance().removeSeatsForObject(id);
    }

    public void updateSynchronizedData(UUID id, ByteBuf data) {
        VxClientBody body = this.managedObjects.get(id);
        if (body != null) {
            try {
                body.getSynchronizedData().readEntries(new VxByteBuf(data));
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Failed to read synchronized data for object {}", (Object)id, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        this.store.clear();
        this.managedObjects.clear();
        this.isClockOffsetInitialized = false;
        this.clockOffsetNanos = 0L;
        List<Long> list = this.clockOffsetSamples;
        synchronized (list) {
            this.clockOffsetSamples.clear();
        }
    }

    public void clientTick() {
        this.synchronizeClock();
        if (this.isClockOffsetInitialized) {
            long renderTimestamp = this.clock.getGameTimeNanos() + this.clockOffsetNanos - 150000000L;
            this.interpolator.updateInterpolationTargets(this.store, renderTimestamp);
        }
    }

    public static void registerEvents() {
        ClientTickEvent.CLIENT_PRE.register(client -> INSTANCE.clientTick());
        VxClientPlayerNetworkEvent.LoggingOut.EVENT.register(event -> INSTANCE.clearAll());
    }

    public VxClientObjectDataStore getStore() {
        return this.store;
    }

    public VxClientObjectInterpolator getInterpolator() {
        return this.interpolator;
    }

    public Collection<VxClientBody> getAllObjects() {
        return this.managedObjects.values();
    }

    public VxClientClock getClock() {
        return this.clock;
    }

    @Nullable
    public VxClientBody getObject(UUID id) {
        return this.managedObjects.get(id);
    }
}

