/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.client.body;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.minecraft.class_238;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.VxRenderState;
import net.xmx.velthoric.physics.object.sync.VxDataAccessor;
import net.xmx.velthoric.physics.object.sync.VxSynchronizedData;

public abstract class VxClientBody {
    protected final UUID id;
    protected final VxClientObjectManager manager;
    protected final int dataStoreIndex;
    protected final EBodyType objectType;
    protected final VxSynchronizedData synchronizedData;

    protected VxClientBody(UUID id, VxClientObjectManager manager, int dataStoreIndex, EBodyType objectType) {
        this.id = id;
        this.manager = manager;
        this.dataStoreIndex = dataStoreIndex;
        this.objectType = objectType;
        this.synchronizedData = new VxSynchronizedData(EnvType.CLIENT);
        this.defineSyncData();
    }

    public abstract void render(class_4587 var1, class_4597.class_4598 var2, float var3, int var4, VxRenderState var5);

    public abstract void calculateRenderState(float var1, VxRenderState var2, RVec3 var3, Quat var4);

    public class_238 getCullingAABB(float inflation) {
        RVec3 lastPos = this.manager.getStore().lastKnownPosition[this.dataStoreIndex];
        return new class_238(lastPos.xx() - (double)inflation, lastPos.yy() - (double)inflation, lastPos.zz() - (double)inflation, lastPos.xx() + (double)inflation, lastPos.yy() + (double)inflation, lastPos.zz() + (double)inflation);
    }

    protected abstract void defineSyncData();

    public <T> T getSyncData(VxDataAccessor<T> accessor) {
        return this.synchronizedData.get(accessor);
    }

    public UUID getId() {
        return this.id;
    }

    public int getDataStoreIndex() {
        return this.dataStoreIndex;
    }

    public boolean isInitialized() {
        return this.manager.getStore().render_isInitialized[this.dataStoreIndex];
    }

    public VxSynchronizedData getSynchronizedData() {
        return this.synchronizedData;
    }
}

