/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.manager;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.ShapeResult;
import com.github.stephengold.joltjni.SoftBodyCreationSettings;
import com.github.stephengold.joltjni.SoftBodySharedSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.class_1923;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.object.VxObjectType;
import net.xmx.velthoric.physics.object.manager.VxObjectDataStore;
import net.xmx.velthoric.physics.object.manager.VxObjectNetworkDispatcher;
import net.xmx.velthoric.physics.object.manager.VxPhysicsUpdater;
import net.xmx.velthoric.physics.object.manager.VxRemovalReason;
import net.xmx.velthoric.physics.object.persistence.VxBodyStorage;
import net.xmx.velthoric.physics.object.registry.VxObjectRegistry;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.object.type.VxRigidBody;
import net.xmx.velthoric.physics.object.type.VxSoftBody;
import net.xmx.velthoric.physics.object.type.factory.VxRigidBodyFactory;
import net.xmx.velthoric.physics.object.type.factory.VxSoftBodyFactory;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public class VxObjectManager {
    private final VxPhysicsWorld world;
    private final VxBodyStorage objectStorage;
    private final VxObjectDataStore dataStore;
    private final VxPhysicsUpdater physicsUpdater;
    private final VxObjectNetworkDispatcher networkDispatcher;
    private final Map<UUID, VxBody> managedObjects = new ConcurrentHashMap<UUID, VxBody>();
    private final Int2ObjectMap<VxBody> bodyIdToObjectMap = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
    private final Long2ObjectMap<List<VxBody>> objectsByChunk = new Long2ObjectOpenHashMap();

    public VxObjectManager(VxPhysicsWorld world) {
        this.world = world;
        this.dataStore = new VxObjectDataStore();
        this.objectStorage = new VxBodyStorage(world.getLevel(), this);
        this.physicsUpdater = new VxPhysicsUpdater(this);
        this.networkDispatcher = new VxObjectNetworkDispatcher(world.getLevel(), this);
    }

    public void initialize() {
        this.objectStorage.initialize();
        this.networkDispatcher.start();
    }

    public void shutdown() {
        this.networkDispatcher.stop();
        this.getAllObjects().forEach(this.objectStorage::storeObject);
        this.objectStorage.saveDirtyRegions();
        this.clear();
        this.objectStorage.shutdown();
    }

    private void clear() {
        this.managedObjects.clear();
        this.bodyIdToObjectMap.clear();
        this.dataStore.clear();
    }

    public void onPhysicsTick(VxPhysicsWorld world) {
        this.physicsUpdater.onPhysicsTick(world);
    }

    public void onGameTick(class_3218 level) {
        this.networkDispatcher.onGameTick();
        this.physicsUpdater.onGameTick(level);
    }

    @Nullable
    public <T extends VxRigidBody> T createRigidBody(VxObjectType<T> type, VxTransform transform, Consumer<T> configurator) {
        VxRigidBody body = (VxRigidBody)type.create(this.world, UUID.randomUUID());
        if (body == null) {
            return null;
        }
        configurator.accept(body);
        this.addConstructedBody(body, EActivation.DontActivate, transform);
        return (T)body;
    }

    @Nullable
    public <T extends VxSoftBody> T createSoftBody(VxObjectType<T> type, VxTransform transform, Consumer<T> configurator) {
        VxSoftBody body = (VxSoftBody)type.create(this.world, UUID.randomUUID());
        if (body == null) {
            return null;
        }
        configurator.accept(body);
        this.addConstructedBody(body, EActivation.DontActivate, transform);
        return (T)body;
    }

    public void addConstructedBody(VxBody body, EActivation activation, VxTransform transform) {
        this.addInternal(body);
        int index = body.getDataStoreIndex();
        if (index != -1) {
            this.dataStore.posX[index] = transform.getTranslation().x();
            this.dataStore.posY[index] = transform.getTranslation().y();
            this.dataStore.posZ[index] = transform.getTranslation().z();
            this.dataStore.rotX[index] = transform.getRotation().getX();
            this.dataStore.rotY[index] = transform.getRotation().getY();
            this.dataStore.rotZ[index] = transform.getRotation().getZ();
            this.dataStore.rotW[index] = transform.getRotation().getW();
        }
        this.networkDispatcher.onObjectAdded(body);
        if (body instanceof VxRigidBody) {
            VxRigidBody rigidBody = (VxRigidBody)body;
            this.addRigidBodyToPhysicsWorld(rigidBody, null, null, activation);
        } else if (body instanceof VxSoftBody) {
            VxSoftBody softBody = (VxSoftBody)body;
            this.addSoftBodyToPhysicsWorld(softBody, activation);
        }
    }

    @Nullable
    public VxBody addSerializedBody(VxBodyStorage.SerializedBodyData data) {
        EActivation activation;
        VxBody obj = VxObjectRegistry.getInstance().create(data.typeId(), this.world, data.id());
        if (obj == null) {
            VxMainClass.LOGGER.error("Failed to create object of type {} with ID {} from storage.", (Object)data.typeId(), (Object)data.id());
            return null;
        }
        this.addInternal(obj);
        int index = obj.getDataStoreIndex();
        if (index != -1) {
            this.dataStore.posX[index] = data.transform().getTranslation().x();
            this.dataStore.posY[index] = data.transform().getTranslation().y();
            this.dataStore.posZ[index] = data.transform().getTranslation().z();
            this.dataStore.rotX[index] = data.transform().getRotation().getX();
            this.dataStore.rotY[index] = data.transform().getRotation().getY();
            this.dataStore.rotZ[index] = data.transform().getRotation().getZ();
            this.dataStore.rotW[index] = data.transform().getRotation().getW();
        }
        obj.readPersistenceData(data.persistenceData());
        data.persistenceData().release();
        this.networkDispatcher.onObjectAdded(obj);
        boolean hasVelocity = data.linearVelocity().lengthSq() > 1.0E-4f || data.angularVelocity().lengthSq() > 1.0E-4f;
        EActivation eActivation = activation = hasVelocity ? EActivation.Activate : EActivation.DontActivate;
        if (obj instanceof VxRigidBody) {
            VxRigidBody rigidBody = (VxRigidBody)obj;
            this.addRigidBodyToPhysicsWorld(rigidBody, data.linearVelocity(), data.angularVelocity(), activation);
        } else if (obj instanceof VxSoftBody) {
            VxSoftBody softBody = (VxSoftBody)obj;
            this.addSoftBodyToPhysicsWorld(softBody, activation);
        }
        return obj;
    }

    private void addRigidBodyToPhysicsWorld(VxRigidBody body, @Nullable Vec3 linearVelocity, @Nullable Vec3 angularVelocity, EActivation activation) {
        try {
            VxRigidBodyFactory factory = (shapeSettings, bcs) -> {
                try (ShapeResult shapeResult = shapeSettings.create();){
                    int n;
                    block15: {
                        if (shapeResult.hasError()) {
                            throw new IllegalStateException("Shape creation failed: " + shapeResult.getError());
                        }
                        ShapeRefC shapeRef = shapeResult.get();
                        try {
                            bcs.setShape(shapeRef);
                            int index = body.getDataStoreIndex();
                            bcs.setPosition(this.dataStore.posX[index], this.dataStore.posY[index], this.dataStore.posZ[index]);
                            bcs.setRotation(new Quat(this.dataStore.rotX[index], this.dataStore.rotY[index], this.dataStore.rotZ[index], this.dataStore.rotW[index]));
                            if (linearVelocity != null) {
                                bcs.setLinearVelocity(linearVelocity);
                            }
                            if (angularVelocity != null) {
                                bcs.setAngularVelocity(angularVelocity);
                            }
                            n = this.world.getBodyInterface().createAndAddBody(bcs, activation);
                            if (shapeRef == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (shapeRef != null) {
                                try {
                                    shapeRef.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        shapeRef.close();
                    }
                    return n;
                }
            };
            int bodyId = body.createJoltBody(factory);
            if (bodyId == -1) {
                VxMainClass.LOGGER.error("Jolt failed to create/add rigid body for {}", (Object)body.getPhysicsId());
                this.removeInternal(body.getPhysicsId());
                return;
            }
            body.setBodyId(bodyId);
            this.bodyIdToObjectMap.put(bodyId, (Object)body);
            body.onBodyAdded(this.world);
            this.world.getConstraintManager().getDataSystem().onDependencyLoaded(body.getPhysicsId());
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Failed to create/add rigid body {}", (Object)body.getPhysicsId(), (Object)e);
            this.removeInternal(body.getPhysicsId());
        }
    }

    private void addSoftBodyToPhysicsWorld(VxSoftBody body, EActivation activation) {
        try {
            VxSoftBodyFactory factory = (sharedSettings, creationSettings) -> {
                try (SoftBodySharedSettings softBodySharedSettings = sharedSettings;){
                    int n;
                    block12: {
                        SoftBodyCreationSettings softBodyCreationSettings = creationSettings;
                        try {
                            int index = body.getDataStoreIndex();
                            creationSettings.setPosition(this.dataStore.posX[index], this.dataStore.posY[index], this.dataStore.posZ[index]);
                            creationSettings.setRotation(new Quat(this.dataStore.rotX[index], this.dataStore.rotY[index], this.dataStore.rotZ[index], this.dataStore.rotW[index]));
                            n = this.world.getBodyInterface().createAndAddSoftBody(creationSettings, activation);
                            if (softBodyCreationSettings == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (softBodyCreationSettings != null) {
                                try {
                                    softBodyCreationSettings.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        softBodyCreationSettings.close();
                    }
                    return n;
                }
            };
            int bodyId = body.createJoltBody(factory);
            if (bodyId == -1) {
                VxMainClass.LOGGER.error("Jolt failed to create/add soft body for {}", (Object)body.getPhysicsId());
                this.removeInternal(body.getPhysicsId());
                return;
            }
            body.setBodyId(bodyId);
            this.bodyIdToObjectMap.put(bodyId, (Object)body);
            body.onBodyAdded(this.world);
            this.world.getConstraintManager().getDataSystem().onDependencyLoaded(body.getPhysicsId());
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Failed to create/add soft body {}", (Object)body.getPhysicsId(), (Object)e);
            this.removeInternal(body.getPhysicsId());
        }
    }

    private void addInternal(VxBody obj) {
        if (obj == null) {
            return;
        }
        this.managedObjects.computeIfAbsent(obj.getPhysicsId(), id -> {
            EBodyType type = obj instanceof VxSoftBody ? EBodyType.SoftBody : EBodyType.RigidBody;
            int index = this.dataStore.addObject((UUID)id, type);
            obj.setDataStoreIndex(index);
            this.startTracking(obj);
            return obj;
        });
    }

    @Nullable
    private synchronized VxBody removeInternal(UUID id) {
        VxBody obj = this.managedObjects.remove(id);
        if (obj != null) {
            this.dataStore.removeObject(id);
            obj.setDataStoreIndex(-1);
            if (obj.getBodyId() != 0) {
                this.bodyIdToObjectMap.remove(obj.getBodyId());
            }
        }
        return obj;
    }

    public void removeObject(UUID id, VxRemovalReason reason) {
        VxBody obj = this.removeInternal(id);
        if (obj == null) {
            VxMainClass.LOGGER.warn("Attempted to remove non-existent body: {}", (Object)id);
            if (reason == VxRemovalReason.DISCARD) {
                this.objectStorage.removeData(id);
            }
            this.world.getConstraintManager().removeConstraintsForObject(id, reason == VxRemovalReason.DISCARD);
            return;
        }
        this.networkDispatcher.onObjectRemoved(obj);
        this.stopTracking(obj);
        obj.onBodyRemoved(this.world, reason);
        if (reason == VxRemovalReason.SAVE) {
            this.objectStorage.storeObject(obj);
        } else if (reason == VxRemovalReason.DISCARD) {
            this.objectStorage.removeData(id);
        }
        this.world.getConstraintManager().removeConstraintsForObject(id, reason == VxRemovalReason.DISCARD);
        int bodyIdToRemove = obj.getBodyId();
        if (bodyIdToRemove != 0 && bodyIdToRemove != -1) {
            this.world.execute(() -> {
                if (this.world.getBodyInterface().isAdded(bodyIdToRemove)) {
                    this.world.getBodyInterface().removeBody(bodyIdToRemove);
                }
                this.world.getBodyInterface().destroyBody(bodyIdToRemove);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateObjectTracking(VxBody body, long fromKey, long toKey) {
        Long2ObjectMap<List<VxBody>> long2ObjectMap;
        int index = body.getDataStoreIndex();
        if (index != -1) {
            this.dataStore.chunkKey[index] = toKey;
        }
        if (fromKey != Long.MAX_VALUE) {
            long2ObjectMap = this.objectsByChunk;
            synchronized (long2ObjectMap) {
                List fromList = (List)this.objectsByChunk.get(fromKey);
                if (fromList != null) {
                    fromList.remove(body);
                    if (fromList.isEmpty()) {
                        this.objectsByChunk.remove(fromKey);
                    }
                }
            }
        }
        long2ObjectMap = this.objectsByChunk;
        synchronized (long2ObjectMap) {
            ((List)this.objectsByChunk.computeIfAbsent(toKey, k -> new CopyOnWriteArrayList())).add(body);
        }
        this.networkDispatcher.onObjectMoved(body, new class_1923(fromKey), new class_1923(toKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTracking(VxBody body) {
        long key;
        int index = body.getDataStoreIndex();
        if (index == -1) {
            return;
        }
        this.dataStore.chunkKey[index] = key = this.getObjectChunkPos(index).method_8324();
        Long2ObjectMap<List<VxBody>> long2ObjectMap = this.objectsByChunk;
        synchronized (long2ObjectMap) {
            ((List)this.objectsByChunk.computeIfAbsent(key, k -> new CopyOnWriteArrayList())).add(body);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTracking(VxBody body) {
        int index = body.getDataStoreIndex();
        if (index == -1) {
            return;
        }
        long key = this.dataStore.chunkKey[index];
        if (key != Long.MAX_VALUE) {
            Long2ObjectMap<List<VxBody>> long2ObjectMap = this.objectsByChunk;
            synchronized (long2ObjectMap) {
                List list = (List)this.objectsByChunk.get(key);
                if (list != null) {
                    list.remove(body);
                    if (list.isEmpty()) {
                        this.objectsByChunk.remove(key);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VxBody> getObjectsInChunk(class_1923 pos) {
        Long2ObjectMap<List<VxBody>> long2ObjectMap = this.objectsByChunk;
        synchronized (long2ObjectMap) {
            return (List)this.objectsByChunk.getOrDefault(pos.method_8324(), Collections.emptyList());
        }
    }

    @Nullable
    public VxBody getByBodyId(int bodyId) {
        return (VxBody)this.bodyIdToObjectMap.get(bodyId);
    }

    public Collection<VxBody> getAllObjects() {
        return this.managedObjects.values();
    }

    @Nullable
    public VxBody getObject(UUID id) {
        return this.managedObjects.get(id);
    }

    public void markCustomDataDirty(VxBody body) {
        if (body.getDataStoreIndex() != -1) {
            this.getDataStore().isCustomDataDirty[body.getDataStoreIndex()] = true;
        }
    }

    public CompletableFuture<VxBody> getOrLoadObject(UUID id) {
        if (id == null) {
            return CompletableFuture.completedFuture(null);
        }
        VxBody loadedObject = this.getObject(id);
        if (loadedObject != null) {
            return CompletableFuture.completedFuture(loadedObject);
        }
        return this.objectStorage.loadObject(id);
    }

    public void onChunkUnload(class_1923 chunkPos) {
        List<VxBody> objectsInChunk = this.getObjectsInChunk(chunkPos);
        if (objectsInChunk.isEmpty()) {
            return;
        }
        for (VxBody obj : List.copyOf(objectsInChunk)) {
            this.removeObject(obj.getPhysicsId(), VxRemovalReason.SAVE);
        }
    }

    public void saveAll() {
        VxPhysicsWorld physicsWorld = this.getPhysicsWorld();
        if (physicsWorld != null && physicsWorld.isRunning()) {
            physicsWorld.execute(() -> {
                Collection<VxBody> allObjects = this.getAllObjects();
                if (!allObjects.isEmpty()) {
                    this.objectStorage.storeObjects(allObjects);
                }
                this.objectStorage.saveDirtyRegions();
            });
        }
    }

    public void getTransform(int dataStoreIndex, VxTransform out) {
        if (dataStoreIndex >= 0 && dataStoreIndex < this.dataStore.getCapacity()) {
            out.getTranslation().set(this.dataStore.posX[dataStoreIndex], this.dataStore.posY[dataStoreIndex], this.dataStore.posZ[dataStoreIndex]);
            out.getRotation().set(this.dataStore.rotX[dataStoreIndex], this.dataStore.rotY[dataStoreIndex], this.dataStore.rotZ[dataStoreIndex], this.dataStore.rotW[dataStoreIndex]);
        }
    }

    public class_1923 getObjectChunkPos(int dataStoreIndex) {
        if (dataStoreIndex >= 0 && dataStoreIndex < this.dataStore.getCapacity()) {
            return new class_1923(class_4076.method_32204((double)this.dataStore.posX[dataStoreIndex]), class_4076.method_32204((double)this.dataStore.posZ[dataStoreIndex]));
        }
        return new class_1923(0, 0);
    }

    public VxPhysicsWorld getPhysicsWorld() {
        return this.world;
    }

    public VxObjectDataStore getDataStore() {
        return this.dataStore;
    }

    public VxBodyStorage getObjectStorage() {
        return this.objectStorage;
    }

    public VxObjectNetworkDispatcher getNetworkDispatcher() {
        return this.networkDispatcher;
    }
}

