/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.manager;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_1923;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.network.VxPacketHandler;
import net.xmx.velthoric.physics.object.manager.VxObjectDataStore;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.object.packet.VxSpawnData;
import net.xmx.velthoric.physics.object.packet.batch.S2CRemoveBodyBatchPacket;
import net.xmx.velthoric.physics.object.packet.batch.S2CSpawnBodyBatchPacket;
import net.xmx.velthoric.physics.object.packet.batch.S2CSynchronizedDataBatchPacket;
import net.xmx.velthoric.physics.object.packet.batch.S2CUpdateBodyStateBatchPacket;
import net.xmx.velthoric.physics.object.packet.batch.S2CUpdateVerticesBatchPacket;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.vehicle.sync.VxWheelNetworkDispatcher;

public class VxObjectNetworkDispatcher {
    private final class_3218 level;
    private final VxObjectManager manager;
    private final VxObjectDataStore dataStore;
    private final VxWheelNetworkDispatcher wheelDispatcher;
    private static final int NETWORK_THREAD_TICK_RATE_MS = 10;
    private static final int MAX_STATES_PER_PACKET = 50;
    private static final int MAX_VERTICES_PER_PACKET = 50;
    private static final int MAX_PACKET_PAYLOAD_SIZE = 131072;
    private static final int MAX_REMOVALS_PER_PACKET = 512;
    private final Map<UUID, Set<UUID>> playerTrackedObjects = new ConcurrentHashMap<UUID, Set<UUID>>();
    private final Map<UUID, class_1923> playerChunkPositions = new ConcurrentHashMap<UUID, class_1923>();
    private final Map<UUID, Integer> playerViewDistances = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Set<class_3222>> objectTrackers = new ConcurrentHashMap<UUID, Set<class_3222>>();
    private final Map<class_3222, ObjectArrayList<VxSpawnData>> pendingSpawns = new HashMap<class_3222, ObjectArrayList<VxSpawnData>>();
    private final Map<class_3222, ObjectArrayList<UUID>> pendingRemovals = new HashMap<class_3222, ObjectArrayList<UUID>>();
    private ExecutorService networkSyncExecutor;

    public VxObjectNetworkDispatcher(class_3218 level, VxObjectManager manager) {
        this.level = level;
        this.manager = manager;
        this.dataStore = manager.getDataStore();
        this.wheelDispatcher = new VxWheelNetworkDispatcher();
    }

    public void start() {
        this.networkSyncExecutor = Executors.newSingleThreadExecutor(r -> new Thread(r, "Velthoric-Network-Sync-Thread"));
        this.networkSyncExecutor.submit(this::runSyncLoop);
    }

    public void stop() {
        if (this.networkSyncExecutor != null) {
            this.networkSyncExecutor.shutdownNow();
        }
    }

    public void onGameTick() {
        this.processPendingRemovals();
        this.processPendingSpawns();
    }

    private void runSyncLoop() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                long cycleStartTime = System.nanoTime();
                this.sendStateUpdates();
                this.sendSynchronizedDataUpdates();
                this.wheelDispatcher.dispatchUpdates(this.level, this.manager, this.objectTrackers);
                long cycleEndTime = System.nanoTime();
                long cycleDurationMs = (cycleEndTime - cycleStartTime) / 1000000L;
                long sleepTime = Math.max(0L, 10L - cycleDurationMs);
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Exception in Velthoric Network Sync Thread", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStateUpdates() {
        IntArrayList dirtyTransformIndices = new IntArrayList();
        IntArrayList dirtyVertexIndices = new IntArrayList();
        VxObjectDataStore vxObjectDataStore = this.dataStore;
        synchronized (vxObjectDataStore) {
            for (int i = 0; i < this.dataStore.getCapacity(); ++i) {
                if (this.dataStore.isTransformDirty[i]) {
                    dirtyTransformIndices.add(i);
                    this.dataStore.isTransformDirty[i] = false;
                }
                if (!this.dataStore.isVertexDataDirty[i]) continue;
                dirtyVertexIndices.add(i);
                this.dataStore.isVertexDataDirty[i] = false;
            }
        }
        if (dirtyTransformIndices.isEmpty() && dirtyVertexIndices.isEmpty()) {
            return;
        }
        Object2ObjectOpenHashMap transformUpdatesByPlayer = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap vertexUpdatesByPlayer = new Object2ObjectOpenHashMap();
        this.groupUpdatesByPlayer(dirtyTransformIndices, (Map<class_3222, IntArrayList>)transformUpdatesByPlayer);
        this.groupUpdatesByPlayer(dirtyVertexIndices, (Map<class_3222, IntArrayList>)vertexUpdatesByPlayer);
        if (!transformUpdatesByPlayer.isEmpty() || !vertexUpdatesByPlayer.isEmpty()) {
            this.level.method_8503().execute(() -> this.lambda$sendStateUpdates$1((Map)transformUpdatesByPlayer, (Map)vertexUpdatesByPlayer));
        }
    }

    private void groupUpdatesByPlayer(IntArrayList dirtyIndices, Map<class_3222, IntArrayList> updatesByPlayer) {
        IntListIterator intListIterator = dirtyIndices.iterator();
        while (intListIterator.hasNext()) {
            Set<class_3222> trackers;
            int dirtyIndex = (Integer)intListIterator.next();
            UUID objectId = this.dataStore.getIdForIndex(dirtyIndex);
            if (objectId == null || (trackers = this.objectTrackers.get(objectId)) == null) continue;
            for (class_3222 player : trackers) {
                updatesByPlayer.computeIfAbsent(player, k -> new IntArrayList()).add(dirtyIndex);
            }
        }
    }

    private void sendBodyStatePackets(class_3222 player, IntArrayList indices) {
        if (player.field_13987 == null || indices.isEmpty()) {
            return;
        }
        UUID[] ids = new UUID[50];
        long[] timestamps = new long[50];
        double[] posX = new double[50];
        double[] posY = new double[50];
        double[] posZ = new double[50];
        float[] rotX = new float[50];
        float[] rotY = new float[50];
        float[] rotZ = new float[50];
        float[] rotW = new float[50];
        float[] velX = new float[50];
        float[] velY = new float[50];
        float[] velZ = new float[50];
        boolean[] isActive = new boolean[50];
        int currentBatchCount = 0;
        IntListIterator intListIterator = indices.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            UUID uuid = this.dataStore.getIdForIndex(index);
            if (uuid == null) continue;
            ids[currentBatchCount] = uuid;
            timestamps[currentBatchCount] = this.dataStore.lastUpdateTimestamp[index];
            posX[currentBatchCount] = this.dataStore.posX[index];
            posY[currentBatchCount] = this.dataStore.posY[index];
            posZ[currentBatchCount] = this.dataStore.posZ[index];
            rotX[currentBatchCount] = this.dataStore.rotX[index];
            rotY[currentBatchCount] = this.dataStore.rotY[index];
            rotZ[currentBatchCount] = this.dataStore.rotZ[index];
            rotW[currentBatchCount] = this.dataStore.rotW[index];
            isActive[currentBatchCount] = this.dataStore.isActive[index];
            velX[currentBatchCount] = this.dataStore.velX[index];
            velY[currentBatchCount] = this.dataStore.velY[index];
            velZ[currentBatchCount] = this.dataStore.velZ[index];
            if (++currentBatchCount != 50) continue;
            S2CUpdateBodyStateBatchPacket packet = new S2CUpdateBodyStateBatchPacket(currentBatchCount, ids, timestamps, posX, posY, posZ, rotX, rotY, rotZ, rotW, velX, velY, velZ, isActive);
            VxPacketHandler.sendToPlayer(packet, player);
            currentBatchCount = 0;
        }
        if (currentBatchCount > 0) {
            S2CUpdateBodyStateBatchPacket packet = new S2CUpdateBodyStateBatchPacket(currentBatchCount, ids, timestamps, posX, posY, posZ, rotX, rotY, rotZ, rotW, velX, velY, velZ, isActive);
            VxPacketHandler.sendToPlayer(packet, player);
        }
    }

    private void sendVertexDataPackets(class_3222 player, IntArrayList indices) {
        if (player.field_13987 == null || indices.isEmpty()) {
            return;
        }
        for (int i = 0; i < indices.size(); i += 50) {
            int end = Math.min(i + 50, indices.size());
            IntList sublist = indices.subList(i, end);
            ObjectArrayList idList = new ObjectArrayList();
            ObjectArrayList vertexList = new ObjectArrayList();
            Iterator iterator = sublist.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                UUID uuid = this.dataStore.getIdForIndex(index);
                if (uuid == null) continue;
                idList.add((Object)uuid);
                vertexList.add((Object)this.dataStore.vertexData[index]);
            }
            if (idList.isEmpty()) continue;
            S2CUpdateVerticesBatchPacket packet = new S2CUpdateVerticesBatchPacket(idList.size(), (UUID[])idList.toArray((Object[])new UUID[0]), (float[][])vertexList.toArray((Object[])new float[0][]));
            VxPacketHandler.sendToPlayer(packet, player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSynchronizedDataUpdates() {
        IntArrayList dirtyDataIndices = new IntArrayList();
        VxObjectDataStore vxObjectDataStore = this.dataStore;
        synchronized (vxObjectDataStore) {
            for (int i = 0; i < this.dataStore.getCapacity(); ++i) {
                if (!this.dataStore.isCustomDataDirty[i]) continue;
                dirtyDataIndices.add(i);
                this.dataStore.isCustomDataDirty[i] = false;
            }
        }
        if (dirtyDataIndices.isEmpty()) {
            return;
        }
        Object2ObjectOpenHashMap updatesByPlayer = new Object2ObjectOpenHashMap();
        IntListIterator intListIterator = dirtyDataIndices.iterator();
        while (intListIterator.hasNext()) {
            VxBody body;
            int dirtyIndex = (Integer)intListIterator.next();
            UUID objectId = this.dataStore.getIdForIndex(dirtyIndex);
            if (objectId == null || (body = this.manager.getObject(objectId)) == null) continue;
            ByteBuf buffer = Unpooled.buffer();
            boolean dataWasWritten = body.writeDirtySyncData(new VxByteBuf(buffer));
            if (dataWasWritten) {
                byte[] data = new byte[buffer.readableBytes()];
                buffer.readBytes(data);
                Set<class_3222> trackers = this.objectTrackers.get(objectId);
                if (trackers != null) {
                    for (class_3222 player : trackers) {
                        updatesByPlayer.computeIfAbsent(player, k -> new Object2ObjectArrayMap()).put(objectId, data);
                    }
                }
            }
            buffer.release();
        }
        if (!updatesByPlayer.isEmpty()) {
            this.level.method_8503().execute(() -> VxObjectNetworkDispatcher.lambda$sendSynchronizedDataUpdates$5((Map)updatesByPlayer));
        }
    }

    public void onObjectAdded(VxBody body) {
        int index = body.getDataStoreIndex();
        if (index == -1) {
            return;
        }
        class_1923 bodyChunk = this.manager.getObjectChunkPos(index);
        for (class_3222 player : this.level.method_18456()) {
            if (!this.isChunkVisible(player, bodyChunk)) continue;
            this.startTracking(player, body);
        }
    }

    public void onObjectRemoved(VxBody body) {
        Set<class_3222> trackers = this.objectTrackers.get(body.getPhysicsId());
        if (trackers != null) {
            for (class_3222 player : new ArrayList<class_3222>(trackers)) {
                this.stopTracking(player, body.getPhysicsId());
            }
        }
    }

    public void onObjectMoved(VxBody body, class_1923 from, class_1923 to) {
        for (class_3222 player : this.level.method_18456()) {
            boolean wasVisible = this.isChunkVisible(player, from);
            boolean isVisible = this.isChunkVisible(player, to);
            if (wasVisible && !isVisible) {
                this.stopTracking(player, body.getPhysicsId());
                continue;
            }
            if (wasVisible || !isVisible) continue;
            this.startTracking(player, body);
        }
    }

    public void updatePlayerTracking(class_3222 player) {
        this.playerChunkPositions.put(player.method_5667(), player.method_31476());
        this.playerViewDistances.put(player.method_5667(), player.field_13995.method_3760().method_14568());
        Set previouslyTracked = this.playerTrackedObjects.computeIfAbsent(player.method_5667(), k -> ConcurrentHashMap.newKeySet());
        HashSet<UUID> newlyVisible = new HashSet<UUID>();
        int viewDistance = this.playerViewDistances.getOrDefault(player.method_5667(), 0);
        class_1923 playerChunkPos = this.playerChunkPositions.getOrDefault(player.method_5667(), new class_1923(0, 0));
        for (int cz = playerChunkPos.field_9180 - viewDistance; cz <= playerChunkPos.field_9180 + viewDistance; ++cz) {
            for (int cx = playerChunkPos.field_9181 - viewDistance; cx <= playerChunkPos.field_9181 + viewDistance; ++cx) {
                for (VxBody body : this.manager.getObjectsInChunk(new class_1923(cx, cz))) {
                    newlyVisible.add(body.getPhysicsId());
                }
            }
        }
        for (UUID trackedId : new ArrayList(previouslyTracked)) {
            if (newlyVisible.contains(trackedId)) continue;
            this.stopTracking(player, trackedId);
        }
        for (UUID visibleId : newlyVisible) {
            VxBody body;
            if (previouslyTracked.contains(visibleId) || (body = this.manager.getObject(visibleId)) == null) continue;
            this.startTracking(player, body);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTracking(class_3222 player, VxBody body) {
        Set trackedByPlayer = this.playerTrackedObjects.computeIfAbsent(player.method_5667(), k -> ConcurrentHashMap.newKeySet());
        if (trackedByPlayer.add(body.getPhysicsId())) {
            this.objectTrackers.computeIfAbsent(body.getPhysicsId(), k -> ConcurrentHashMap.newKeySet()).add(player);
            Map<class_3222, ObjectArrayList<VxSpawnData>> map = this.pendingSpawns;
            synchronized (map) {
                ObjectArrayList<UUID> removals = this.pendingRemovals.get(player);
                if (removals != null && removals.remove((Object)body.getPhysicsId())) {
                    return;
                }
                this.pendingSpawns.computeIfAbsent(player, k -> new ObjectArrayList()).add((Object)new VxSpawnData(body, System.nanoTime()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTracking(class_3222 player, UUID bodyId) {
        Set<UUID> trackedByPlayer = this.playerTrackedObjects.get(player.method_5667());
        if (trackedByPlayer != null && trackedByPlayer.remove(bodyId)) {
            Set<class_3222> trackers = this.objectTrackers.get(bodyId);
            if (trackers != null) {
                trackers.remove(player);
                if (trackers.isEmpty()) {
                    this.objectTrackers.remove(bodyId);
                }
            }
            Map<class_3222, ObjectArrayList<VxSpawnData>> map = this.pendingSpawns;
            synchronized (map) {
                ObjectArrayList<VxSpawnData> spawns = this.pendingSpawns.get(player);
                if (spawns != null && spawns.removeIf(spawnData -> spawnData.id.equals(bodyId))) {
                    return;
                }
                this.pendingRemovals.computeIfAbsent(player, k -> new ObjectArrayList()).add((Object)bodyId);
            }
        }
    }

    private boolean isChunkVisible(class_3222 player, class_1923 chunkPos) {
        Integer viewDistance = this.playerViewDistances.get(player.method_5667());
        class_1923 playerChunkPos = this.playerChunkPositions.get(player.method_5667());
        if (viewDistance == null || playerChunkPos == null) {
            return false;
        }
        return Math.abs(chunkPos.field_9181 - playerChunkPos.field_9181) <= viewDistance && Math.abs(chunkPos.field_9180 - playerChunkPos.field_9180) <= viewDistance;
    }

    public void onPlayerJoin(class_3222 player) {
        this.updatePlayerTracking(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlayerDisconnect(class_3222 player) {
        UUID playerId = player.method_5667();
        Set<UUID> trackedObjects = this.playerTrackedObjects.remove(playerId);
        if (trackedObjects != null) {
            for (UUID objectId : trackedObjects) {
                Set<class_3222> trackers = this.objectTrackers.get(objectId);
                if (trackers == null) continue;
                trackers.remove(player);
                if (!trackers.isEmpty()) continue;
                this.objectTrackers.remove(objectId);
            }
        }
        this.playerChunkPositions.remove(playerId);
        this.playerViewDistances.remove(playerId);
        Map<class_3222, ObjectArrayList<UUID>> map = this.pendingSpawns;
        synchronized (map) {
            this.pendingSpawns.remove(player);
        }
        map = this.pendingRemovals;
        synchronized (map) {
            this.pendingRemovals.remove(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingRemovals() {
        if (this.pendingRemovals.isEmpty()) {
            return;
        }
        Map<class_3222, ObjectArrayList<UUID>> map = this.pendingRemovals;
        synchronized (map) {
            this.pendingRemovals.forEach((player, removalList) -> {
                if (!removalList.isEmpty()) {
                    for (int i = 0; i < removalList.size(); i += 512) {
                        int end = Math.min(i + 512, removalList.size());
                        VxPacketHandler.sendToPlayer(new S2CRemoveBodyBatchPacket((List<UUID>)removalList.subList(i, end)), player);
                    }
                }
            });
            this.pendingRemovals.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingSpawns() {
        if (this.pendingSpawns.isEmpty()) {
            return;
        }
        Map<class_3222, ObjectArrayList<VxSpawnData>> map = this.pendingSpawns;
        synchronized (map) {
            this.pendingSpawns.forEach((player, spawnDataList) -> {
                if (!spawnDataList.isEmpty()) {
                    ObjectArrayList batch = new ObjectArrayList();
                    int currentBatchSizeBytes = 0;
                    for (VxSpawnData data : spawnDataList) {
                        int dataSize = data.estimateSize();
                        if (!batch.isEmpty() && currentBatchSizeBytes + dataSize > 131072) {
                            VxPacketHandler.sendToPlayer(new S2CSpawnBodyBatchPacket((List<VxSpawnData>)batch), player);
                            batch.clear();
                            currentBatchSizeBytes = 0;
                        }
                        batch.add((Object)data);
                        currentBatchSizeBytes += dataSize;
                    }
                    if (!batch.isEmpty()) {
                        VxPacketHandler.sendToPlayer(new S2CSpawnBodyBatchPacket((List<VxSpawnData>)batch), player);
                    }
                }
            });
            this.pendingSpawns.clear();
        }
    }

    private static /* synthetic */ void lambda$sendSynchronizedDataUpdates$5(Map updatesByPlayer) {
        updatesByPlayer.forEach((player, dataMap) -> {
            if (!dataMap.isEmpty()) {
                VxPacketHandler.sendToPlayer(new S2CSynchronizedDataBatchPacket((Map<UUID, byte[]>)dataMap), player);
            }
        });
    }

    private /* synthetic */ void lambda$sendStateUpdates$1(Map transformUpdatesByPlayer, Map vertexUpdatesByPlayer) {
        transformUpdatesByPlayer.forEach(this::sendBodyStatePackets);
        vertexUpdatesByPlayer.forEach(this::sendVertexDataPackets);
    }
}

