/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.manager;

import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.BodyLockRead;
import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.readonly.ConstBody;
import com.github.stephengold.joltjni.readonly.ConstBodyLockInterfaceNoLock;
import com.github.stephengold.joltjni.readonly.ConstSoftBodyMotionProperties;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.xmx.velthoric.physics.object.manager.VxObjectDataStore;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.object.type.VxSoftBody;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public class VxPhysicsUpdater {
    private final VxObjectManager manager;
    private final VxObjectDataStore dataStore;
    private final ThreadLocal<RVec3> tempPos = ThreadLocal.withInitial(RVec3::new);
    private final ThreadLocal<Quat> tempRot = ThreadLocal.withInitial(Quat::new);
    private final ThreadLocal<Vec3> tempLinVel = ThreadLocal.withInitial(Vec3::new);
    private final ThreadLocal<Vec3> tempAngVel = ThreadLocal.withInitial(Vec3::new);

    public VxPhysicsUpdater(VxObjectManager manager) {
        this.manager = manager;
        this.dataStore = manager.getDataStore();
    }

    public void onPhysicsTick(VxPhysicsWorld world) {
        this.update(System.nanoTime(), world);
    }

    public void onGameTick(class_3218 level) {
        this.manager.getAllObjects().forEach(obj -> obj.gameTick(level));
    }

    private void update(long timestampNanos, VxPhysicsWorld world) {
        BodyInterface bodyInterface = world.getPhysicsSystem().getBodyInterfaceNoLock();
        this.preUpdateSync(bodyInterface);
        this.postUpdateSync(timestampNanos, world, bodyInterface);
    }

    private void preUpdateSync(BodyInterface bodyInterface) {
        for (int i = 0; i < this.dataStore.getCapacity(); ++i) {
            int bodyId;
            if (!this.dataStore.isGameStateDirty[i]) continue;
            UUID id = this.dataStore.getIdForIndex(i);
            if (id == null) {
                this.dataStore.isGameStateDirty[i] = false;
                continue;
            }
            VxBody body = this.manager.getObject(id);
            if (body != null && (bodyId = body.getBodyId()) != 0 && bodyInterface.isAdded(bodyId)) {
                RVec3 pos = this.tempPos.get();
                pos.set(this.dataStore.posX[i], this.dataStore.posY[i], this.dataStore.posZ[i]);
                Quat rot = this.tempRot.get();
                rot.set(this.dataStore.rotX[i], this.dataStore.rotY[i], this.dataStore.rotZ[i], this.dataStore.rotW[i]);
                bodyInterface.setPositionAndRotation(bodyId, pos, rot, EActivation.Activate);
                Vec3 linVel = this.tempLinVel.get();
                linVel.set(this.dataStore.velX[i], this.dataStore.velY[i], this.dataStore.velZ[i]);
                bodyInterface.setLinearVelocity(bodyId, linVel);
                Vec3 angVel = this.tempAngVel.get();
                angVel.set(this.dataStore.angVelX[i], this.dataStore.angVelY[i], this.dataStore.angVelZ[i]);
                bodyInterface.setAngularVelocity(bodyId, angVel);
            }
            this.dataStore.isGameStateDirty[i] = false;
        }
    }

    private void postUpdateSync(long timestampNanos, VxPhysicsWorld world, BodyInterface bodyInterface) {
        for (int i = 0; i < this.dataStore.getCapacity(); ++i) {
            int bodyId;
            VxBody obj;
            UUID id = this.dataStore.getIdForIndex(i);
            if (id == null || (obj = this.manager.getObject(id)) == null || (bodyId = obj.getBodyId()) == 0 || !bodyInterface.isAdded(bodyId)) continue;
            boolean isJoltBodyActive = bodyInterface.isActive(bodyId);
            boolean wasDataStoreBodyActive = this.dataStore.isActive[i];
            if (!isJoltBodyActive && !wasDataStoreBodyActive) continue;
            obj.physicsTick(world);
            RVec3 pos = this.tempPos.get();
            Quat rot = this.tempRot.get();
            bodyInterface.getPositionAndRotation(bodyId, pos, rot);
            this.dataStore.posX[i] = pos.x();
            this.dataStore.posY[i] = pos.y();
            this.dataStore.posZ[i] = pos.z();
            this.dataStore.rotX[i] = rot.getX();
            this.dataStore.rotY[i] = rot.getY();
            this.dataStore.rotZ[i] = rot.getZ();
            this.dataStore.rotW[i] = rot.getW();
            Vec3 linVel = this.tempLinVel.get();
            bodyInterface.getLinearVelocity(bodyId, linVel);
            this.dataStore.velX[i] = linVel.getX();
            this.dataStore.velY[i] = linVel.getY();
            this.dataStore.velZ[i] = linVel.getZ();
            Vec3 angVel = this.tempAngVel.get();
            bodyInterface.getAngularVelocity(bodyId, angVel);
            this.dataStore.angVelX[i] = angVel.getX();
            this.dataStore.angVelY[i] = angVel.getY();
            this.dataStore.angVelZ[i] = angVel.getZ();
            if (obj instanceof VxSoftBody) {
                VxSoftBody softBody = (VxSoftBody)obj;
                float[] newVertexData = this.getSoftBodyVertices(world.getBodyLockInterfaceNoLock(), bodyId, pos);
                if (newVertexData != null && !Arrays.equals(newVertexData, this.dataStore.vertexData[i])) {
                    this.dataStore.vertexData[i] = newVertexData;
                    this.dataStore.isVertexDataDirty[i] = true;
                    softBody.setLastSyncedVertexData(newVertexData);
                }
            }
            this.dataStore.isActive[i] = isJoltBodyActive;
            this.dataStore.lastUpdateTimestamp[i] = timestampNanos;
            long lastKey = this.dataStore.chunkKey[i];
            long currentKey = new class_1923(class_4076.method_32204((double)pos.x()), class_4076.method_32204((double)pos.z())).method_8324();
            if (lastKey != currentKey) {
                this.manager.updateObjectTracking(obj, lastKey, currentKey);
            }
            this.dataStore.isTransformDirty[i] = true;
        }
    }

    private float @Nullable [] getSoftBodyVertices(ConstBodyLockInterfaceNoLock lockInterface, int bodyId, RVec3Arg bodyPosition) {
        try (BodyLockRead lock = new BodyLockRead(lockInterface, bodyId);){
            ConstSoftBodyMotionProperties motionProps;
            int numVertices;
            ConstBody body;
            if (lock.succeededAndIsInBroadPhase() && (body = lock.getBody()).isSoftBody() && (numVertices = (motionProps = (ConstSoftBodyMotionProperties)body.getMotionProperties()).getSettings().countVertices()) > 0) {
                int bufferSize = numVertices * 3;
                FloatBuffer vertexBuffer = Jolt.newDirectFloatBuffer(bufferSize);
                motionProps.putVertexLocations(bodyPosition, vertexBuffer);
                vertexBuffer.flip();
                float[] vertexArray = new float[bufferSize];
                vertexBuffer.get(vertexArray);
                float[] fArray = vertexArray;
                return fArray;
            }
        }
        return null;
    }
}

