/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.manager.event;

import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.xmx.velthoric.event.api.VxChunkEvent;
import net.xmx.velthoric.event.api.VxLevelEvent;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class ObjectLifecycleEvents {
    public static void registerEvents() {
        VxChunkEvent.Load.EVENT.register(ObjectLifecycleEvents::onChunkLoad);
        VxChunkEvent.Unload.EVENT.register(ObjectLifecycleEvents::onChunkUnload);
        VxLevelEvent.Save.EVENT.register(ObjectLifecycleEvents::onLevelSave);
    }

    private static Optional<VxObjectManager> getObjectManager(class_1937 level) {
        if (level.method_8608()) {
            return Optional.empty();
        }
        VxPhysicsWorld world = VxPhysicsWorld.get((class_5321<class_1937>)level.method_27983());
        return world != null ? Optional.ofNullable(world.getObjectManager()) : Optional.empty();
    }

    private static void onChunkLoad(VxChunkEvent.Load event) {
        ObjectLifecycleEvents.getObjectManager((class_1937)event.getLevel()).ifPresent(manager -> manager.getObjectStorage().loadObjectsInChunk(event.getChunkPos()));
    }

    private static void onChunkUnload(VxChunkEvent.Unload event) {
        ObjectLifecycleEvents.getObjectManager((class_1937)event.getLevel()).ifPresent(manager -> manager.onChunkUnload(event.getChunkPos()));
    }

    private static void onLevelSave(VxLevelEvent.Save event) {
        ObjectLifecycleEvents.getObjectManager((class_1937)event.getLevel()).ifPresent(VxObjectManager::saveAll);
    }
}

