/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.packet;

import com.github.stephengold.joltjni.enumerate.EBodyType;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.object.type.VxSoftBody;
import net.xmx.velthoric.physics.riding.VxRideable;
import net.xmx.velthoric.physics.riding.manager.VxRidingManager;
import net.xmx.velthoric.physics.riding.seat.VxSeat;

public class VxSpawnData {
    public final UUID id;
    public final class_2960 typeIdentifier;
    public final EBodyType objectType;
    public final long timestamp;
    public final byte[] data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VxSpawnData(VxBody obj, long timestamp) {
        this.id = obj.getPhysicsId();
        this.typeIdentifier = obj.getType().getTypeId();
        this.objectType = obj instanceof VxSoftBody ? EBodyType.SoftBody : EBodyType.RigidBody;
        this.timestamp = timestamp;
        VxByteBuf buf = new VxByteBuf(Unpooled.buffer());
        try {
            obj.getTransform().toBuffer(buf);
            obj.writeInitialSyncData(buf);
            if (obj instanceof VxRideable) {
                VxRidingManager ridingManager = obj.getWorld().getRidingManager();
                Collection<VxSeat> seats = ridingManager.getSeats(obj.getPhysicsId());
                buf.method_10804(seats.size());
                for (VxSeat seat : seats) {
                    seat.encode(buf);
                }
            } else {
                buf.method_10804(0);
            }
            this.data = new byte[buf.readableBytes()];
            buf.readBytes(this.data);
        }
        finally {
            if (buf.refCnt() > 0) {
                buf.release();
            }
        }
    }

    public VxSpawnData(class_2540 buf) {
        this.id = buf.method_10790();
        this.typeIdentifier = buf.method_10810();
        this.objectType = (EBodyType)buf.method_10818(EBodyType.class);
        this.timestamp = buf.readLong();
        this.data = buf.method_10795();
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.id);
        buf.method_10812(this.typeIdentifier);
        buf.method_10817((Enum)this.objectType);
        buf.writeLong(this.timestamp);
        buf.method_10813(this.data);
    }

    public int estimateSize() {
        String typeStr = this.typeIdentifier.toString();
        return 16 + class_2540.method_10815((int)typeStr.length()) + typeStr.length() + 4 + 8 + class_2540.method_10815((int)this.data.length) + this.data.length;
    }
}

