/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.packet.batch;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.zip.DataFormatException;
import net.minecraft.class_2540;
import net.xmx.velthoric.network.VxPacketUtils;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;

public class S2CRemoveBodyBatchPacket {
    private final List<UUID> ids;

    public S2CRemoveBodyBatchPacket(List<UUID> ids) {
        this.ids = ids;
    }

    public S2CRemoveBodyBatchPacket(class_2540 buf) {
        byte[] compressedData = buf.method_10795();
        try {
            byte[] decompressedData = VxPacketUtils.decompress(compressedData);
            class_2540 decompressedBuf = new class_2540(Unpooled.wrappedBuffer((byte[])decompressedData));
            int size = decompressedBuf.method_10816();
            this.ids = new ObjectArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.ids.add(decompressedBuf.method_10790());
            }
        }
        catch (IOException | DataFormatException e) {
            throw new IllegalStateException("Failed to decompress remove body batch packet", e);
        }
    }

    public void encode(class_2540 buf) {
        class_2540 tempBuf = new class_2540(Unpooled.buffer());
        try {
            tempBuf.method_10804(this.ids.size());
            for (UUID id : this.ids) {
                tempBuf.method_10797(id);
            }
            byte[] uncompressedData = new byte[tempBuf.readableBytes()];
            tempBuf.readBytes(uncompressedData);
            byte[] compressedData = VxPacketUtils.compress(uncompressedData);
            buf.method_10813(compressedData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compress remove body batch packet", e);
        }
        finally {
            tempBuf.release();
        }
    }

    public static void handle(S2CRemoveBodyBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientObjectManager manager = VxClientObjectManager.getInstance();
            for (UUID id : msg.ids) {
                manager.removeObject(id);
            }
        });
    }
}

