/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.packet.batch;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;

public class S2CSynchronizedDataBatchPacket {
    private final Map<UUID, byte[]> dataUpdates;

    public S2CSynchronizedDataBatchPacket(Map<UUID, byte[]> dataUpdates) {
        this.dataUpdates = dataUpdates;
    }

    public S2CSynchronizedDataBatchPacket(class_2540 buf) {
        int size = buf.method_10816();
        this.dataUpdates = new Object2ObjectArrayMap(size);
        for (int i = 0; i < size; ++i) {
            UUID id = buf.method_10790();
            byte[] data = buf.method_10795();
            this.dataUpdates.put(id, data);
        }
    }

    public void encode(class_2540 buf) {
        buf.method_10804(this.dataUpdates.size());
        for (Map.Entry<UUID, byte[]> entry : this.dataUpdates.entrySet()) {
            buf.method_10797(entry.getKey());
            buf.method_10813(entry.getValue());
        }
    }

    public static void handle(S2CSynchronizedDataBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientObjectManager manager = VxClientObjectManager.getInstance();
            for (Map.Entry<UUID, byte[]> entry : msg.dataUpdates.entrySet()) {
                manager.updateSynchronizedData(entry.getKey(), Unpooled.wrappedBuffer((byte[])entry.getValue()));
            }
        });
    }
}

