/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.packet.batch;

import com.github.stephengold.joltjni.RVec3;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.xmx.velthoric.physics.object.client.VxClientObjectDataStore;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;

public class S2CUpdateBodyStateBatchPacket {
    private final int count;
    private final UUID[] ids;
    private final long[] timestamps;
    private final double[] posX;
    private final double[] posY;
    private final double[] posZ;
    private final float[] rotX;
    private final float[] rotY;
    private final float[] rotZ;
    private final float[] rotW;
    private final float[] velX;
    private final float[] velY;
    private final float[] velZ;
    private final boolean[] isActive;

    public S2CUpdateBodyStateBatchPacket(int count, UUID[] ids, long[] timestamps, double[] posX, double[] posY, double[] posZ, float[] rotX, float[] rotY, float[] rotZ, float[] rotW, float[] velX, float[] velY, float[] velZ, boolean[] isActive) {
        this.count = count;
        this.ids = ids;
        this.timestamps = timestamps;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.rotX = rotX;
        this.rotY = rotY;
        this.rotZ = rotZ;
        this.rotW = rotW;
        this.velX = velX;
        this.velY = velY;
        this.velZ = velZ;
        this.isActive = isActive;
    }

    public S2CUpdateBodyStateBatchPacket(class_2540 buf) {
        this.count = buf.method_10816();
        this.ids = new UUID[this.count];
        this.timestamps = new long[this.count];
        this.posX = new double[this.count];
        this.posY = new double[this.count];
        this.posZ = new double[this.count];
        this.rotX = new float[this.count];
        this.rotY = new float[this.count];
        this.rotZ = new float[this.count];
        this.rotW = new float[this.count];
        this.velX = new float[this.count];
        this.velY = new float[this.count];
        this.velZ = new float[this.count];
        this.isActive = new boolean[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.ids[i] = buf.method_10790();
            this.timestamps[i] = buf.readLong();
            this.posX[i] = buf.readDouble();
            this.posY[i] = buf.readDouble();
            this.posZ[i] = buf.readDouble();
            this.rotX[i] = buf.readFloat();
            this.rotY[i] = buf.readFloat();
            this.rotZ[i] = buf.readFloat();
            this.rotW[i] = buf.readFloat();
            this.isActive[i] = buf.readBoolean();
            if (!this.isActive[i]) continue;
            this.velX[i] = buf.readFloat();
            this.velY[i] = buf.readFloat();
            this.velZ[i] = buf.readFloat();
        }
    }

    public void encode(class_2540 buf) {
        buf.method_10804(this.count);
        for (int i = 0; i < this.count; ++i) {
            UUID uuid = this.ids[i];
            if (uuid == null) {
                buf.method_10797(new UUID(0L, 0L));
            } else {
                buf.method_10797(uuid);
            }
            buf.writeLong(this.timestamps[i]);
            buf.writeDouble(this.posX[i]);
            buf.writeDouble(this.posY[i]);
            buf.writeDouble(this.posZ[i]);
            buf.writeFloat(this.rotX[i]);
            buf.writeFloat(this.rotY[i]);
            buf.writeFloat(this.rotZ[i]);
            buf.writeFloat(this.rotW[i]);
            buf.writeBoolean(this.isActive[i]);
            if (!this.isActive[i]) continue;
            buf.writeFloat(this.velX[i]);
            buf.writeFloat(this.velY[i]);
            buf.writeFloat(this.velZ[i]);
        }
    }

    public static void handle(S2CUpdateBodyStateBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientObjectManager manager = VxClientObjectManager.getInstance();
            VxClientObjectDataStore store = manager.getStore();
            long clientReceiptTime = manager.getClock().getGameTimeNanos();
            for (int i = 0; i < msg.count; ++i) {
                Integer index;
                if (msg.ids[i].getMostSignificantBits() == 0L && msg.ids[i].getLeastSignificantBits() == 0L || (index = store.getIndexForId(msg.ids[i])) == null) continue;
                manager.addClockSyncSample(msg.timestamps[i] - clientReceiptTime);
                store.state0_timestamp[index.intValue()] = store.state1_timestamp[index];
                store.state0_posX[index.intValue()] = store.state1_posX[index];
                store.state0_posY[index.intValue()] = store.state1_posY[index];
                store.state0_posZ[index.intValue()] = store.state1_posZ[index];
                store.state0_rotX[index.intValue()] = store.state1_rotX[index];
                store.state0_rotY[index.intValue()] = store.state1_rotY[index];
                store.state0_rotZ[index.intValue()] = store.state1_rotZ[index];
                store.state0_rotW[index.intValue()] = store.state1_rotW[index];
                store.state0_velX[index.intValue()] = store.state1_velX[index];
                store.state0_velY[index.intValue()] = store.state1_velY[index];
                store.state0_velZ[index.intValue()] = store.state1_velZ[index];
                store.state0_isActive[index.intValue()] = store.state1_isActive[index];
                store.state0_vertexData[index.intValue()] = store.state1_vertexData[index];
                store.state1_timestamp[index.intValue()] = msg.timestamps[i];
                store.state1_posX[index.intValue()] = (float)msg.posX[i];
                store.state1_posY[index.intValue()] = (float)msg.posY[i];
                store.state1_posZ[index.intValue()] = (float)msg.posZ[i];
                store.state1_rotX[index.intValue()] = msg.rotX[i];
                store.state1_rotY[index.intValue()] = msg.rotY[i];
                store.state1_rotZ[index.intValue()] = msg.rotZ[i];
                store.state1_rotW[index.intValue()] = msg.rotW[i];
                store.state1_isActive[index.intValue()] = msg.isActive[i];
                if (store.state1_isActive[index]) {
                    store.state1_velX[index.intValue()] = msg.velX[i];
                    store.state1_velY[index.intValue()] = msg.velY[i];
                    store.state1_velZ[index.intValue()] = msg.velZ[i];
                } else {
                    store.state1_velX[index.intValue()] = 0.0f;
                    store.state1_velY[index.intValue()] = 0.0f;
                    store.state1_velZ[index.intValue()] = 0.0f;
                }
                if (store.lastKnownPosition[index] == null) {
                    store.lastKnownPosition[index.intValue()] = new RVec3();
                }
                store.lastKnownPosition[index].set((float)msg.posX[i], (float)msg.posY[i], (float)msg.posZ[i]);
            }
        });
    }
}

