/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.persistence;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.object.manager.VxObjectDataStore;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.object.persistence.VxBodyCodec;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.persistence.VxAbstractRegionStorage;
import net.xmx.velthoric.physics.persistence.VxRegionIndex;
import org.jetbrains.annotations.Nullable;

public class VxBodyStorage
extends VxAbstractRegionStorage<UUID, byte[]> {
    private final VxObjectManager objectManager;
    private final VxObjectDataStore dataStore;
    private final ConcurrentMap<Long, List<UUID>> chunkToUuidIndex = new ConcurrentHashMap<Long, List<UUID>>();
    private final ConcurrentMap<UUID, CompletableFuture<VxBody>> pendingLoads = new ConcurrentHashMap<UUID, CompletableFuture<VxBody>>();

    public VxBodyStorage(class_3218 level, VxObjectManager objectManager) {
        super(level, "body", "body");
        this.objectManager = objectManager;
        this.dataStore = objectManager.getDataStore();
    }

    @Override
    protected VxRegionIndex createRegionIndex() {
        return new VxRegionIndex(this.storagePath, "body");
    }

    @Override
    protected void readRegionData(ByteBuf buffer, VxAbstractRegionStorage.RegionData<UUID, byte[]> regionData) {
        class_2540 friendlyBuf = new class_2540(buffer);
        while (friendlyBuf.isReadable()) {
            UUID id = friendlyBuf.method_10790();
            byte[] data = friendlyBuf.method_10795();
            regionData.entries.put(id, data);
            this.indexObjectData(id, data);
        }
    }

    @Override
    protected void writeRegionData(ByteBuf buffer, Map<UUID, byte[]> entries) {
        class_2540 friendlyBuf = new class_2540(buffer);
        for (Map.Entry<UUID, byte[]> entry : entries.entrySet()) {
            friendlyBuf.method_10797(entry.getKey());
            friendlyBuf.method_10813(entry.getValue());
        }
    }

    public void storeObjects(Collection<VxBody> objects) {
        for (VxBody object : objects) {
            this.storeObject(object);
        }
    }

    public void storeObject(VxBody object) {
        if (object == null) {
            return;
        }
        int index = object.getDataStoreIndex();
        if (index == -1) {
            return;
        }
        byte[] data = this.serializeObjectData(object, index);
        class_1923 chunkPos = this.objectManager.getObjectChunkPos(index);
        VxAbstractRegionStorage.RegionPos regionPos = new VxAbstractRegionStorage.RegionPos(chunkPos.field_9181 >> 5, chunkPos.field_9180 >> 5);
        ((CompletableFuture)this.getRegion(regionPos).thenAcceptAsync(region -> {
            region.entries.put(object.getPhysicsId(), data);
            region.dirty.set(true);
            this.regionIndex.put(object.getPhysicsId(), regionPos);
            this.indexObjectData(object.getPhysicsId(), data);
        }, (Executor)this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to store object {}", (Object)object.getPhysicsId(), ex);
            return null;
        });
    }

    public void loadObjectsInChunk(class_1923 chunkPos) {
        VxAbstractRegionStorage.RegionPos regionPos = new VxAbstractRegionStorage.RegionPos(chunkPos.field_9181 >> 5, chunkPos.field_9180 >> 5);
        ((CompletableFuture)this.getRegion(regionPos).thenRunAsync(() -> {
            List idsToLoad = (List)this.chunkToUuidIndex.get(chunkPos.method_8324());
            if (idsToLoad == null || idsToLoad.isEmpty()) {
                return;
            }
            for (UUID id : List.copyOf(idsToLoad)) {
                if (this.objectManager.getObject(id) != null || this.pendingLoads.containsKey(id)) continue;
                this.loadObject(id);
            }
        }, this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to load objects in chunk {}", (Object)chunkPos, ex);
            return null;
        });
    }

    public CompletableFuture<VxBody> loadObject(UUID id) {
        VxBody existingObject = this.objectManager.getObject(id);
        if (existingObject != null) {
            return CompletableFuture.completedFuture(existingObject);
        }
        return this.pendingLoads.computeIfAbsent(id, this::loadObjectAsync);
    }

    private CompletableFuture<VxBody> loadObjectAsync(UUID id) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            VxAbstractRegionStorage.RegionPos regionPos = this.regionIndex.get(id);
            if (regionPos == null) {
                return null;
            }
            VxAbstractRegionStorage.RegionData region = this.getRegion(regionPos).join();
            return (byte[])region.entries.get(id);
        }, this.ioExecutor).thenApplyAsync(this::deserializeObject, (Executor)this.ioExecutor)).thenComposeAsync(data -> {
            if (data == null) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture bodyFuture = new CompletableFuture();
            this.objectManager.getPhysicsWorld().execute(() -> {
                try {
                    VxBody body = this.objectManager.addSerializedBody((SerializedBodyData)data);
                    bodyFuture.complete(body);
                }
                catch (Exception e) {
                    bodyFuture.completeExceptionally(e);
                }
            });
            return bodyFuture;
        })).whenComplete((obj, ex) -> {
            if (ex != null) {
                VxMainClass.LOGGER.error("Exception loading physics object {}", (Object)id, ex);
            }
            this.pendingLoads.remove(id);
        });
    }

    public void removeData(UUID id) {
        VxAbstractRegionStorage.RegionPos regionPos = this.regionIndex.get(id);
        if (regionPos == null) {
            return;
        }
        ((CompletableFuture)this.getRegion(regionPos).thenAcceptAsync(region -> {
            byte[] data = (byte[])region.entries.remove(id);
            if (data != null) {
                region.dirty.set(true);
                this.deIndexObject(id, data);
                this.regionIndex.remove(id);
            }
        }, (Executor)this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to remove data for object {}", (Object)id, ex);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private SerializedBodyData deserializeObject(byte[] data) {
        if (data == null) {
            return null;
        }
        VxByteBuf buf = new VxByteBuf(Unpooled.wrappedBuffer((byte[])data));
        try {
            SerializedBodyData serializedBodyData = VxBodyCodec.deserialize(buf);
            return serializedBodyData;
        }
        finally {
            if (buf.refCnt() > 0) {
                buf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeObjectData(VxBody object, int index) {
        ByteBuf buffer = Unpooled.buffer();
        VxByteBuf friendlyBuf = new VxByteBuf(buffer);
        try {
            VxBodyCodec.serialize(object, index, this.dataStore, friendlyBuf);
            byte[] data = new byte[buffer.readableBytes()];
            buffer.readBytes(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            if (buffer.refCnt() > 0) {
                buffer.release();
            }
        }
    }

    private void indexObjectData(UUID id, byte[] data) {
        long chunkKey = this.getChunkKeyFromData(data);
        this.chunkToUuidIndex.computeIfAbsent(chunkKey, k -> new CopyOnWriteArrayList()).add(id);
    }

    private void deIndexObject(UUID id, byte[] data) {
        long chunkKey = this.getChunkKeyFromData(data);
        List idList = (List)this.chunkToUuidIndex.get(chunkKey);
        if (idList != null) {
            idList.remove(id);
            if (idList.isEmpty()) {
                this.chunkToUuidIndex.remove(chunkKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getChunkKeyFromData(byte[] data) {
        class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])data));
        try {
            buf.method_10790();
            buf.method_19772();
            VxTransform tempTransform = new VxTransform();
            tempTransform.fromBuffer(buf);
            RVec3 translation = tempTransform.getTranslation();
            int chunkX = class_4076.method_32204((double)translation.xx());
            int chunkZ = class_4076.method_32204((double)translation.zz());
            long l = new class_1923(chunkX, chunkZ).method_8324();
            return l;
        }
        finally {
            if (buf.refCnt() > 0) {
                buf.release();
            }
        }
    }

    public record SerializedBodyData(class_2960 typeId, UUID id, VxTransform transform, Vec3 linearVelocity, Vec3 angularVelocity, VxByteBuf persistenceData) {
    }
}

