/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.registry;

import com.github.stephengold.joltjni.enumerate.EBodyType;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.object.VxObjectType;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.body.VxClientBody;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public class VxObjectRegistry {
    private static volatile VxObjectRegistry instance;
    private final Map<class_2960, VxObjectType<?>> registeredTypes = new ConcurrentHashMap();
    private final Map<class_2960, ClientFactory> clientFactories = new ConcurrentHashMap<class_2960, ClientFactory>();

    private VxObjectRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VxObjectRegistry getInstance() {
        if (instance != null) return instance;
        Class<VxObjectRegistry> clazz = VxObjectRegistry.class;
        synchronized (VxObjectRegistry.class) {
            if (instance != null) return instance;
            instance = new VxObjectRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void register(VxObjectType<?> type) {
        if (this.registeredTypes.containsKey(type.getTypeId())) {
            VxMainClass.LOGGER.warn("VxObjectType '{}' is already registered. Overwriting.", (Object)type.getTypeId());
        }
        this.registeredTypes.put(type.getTypeId(), type);
    }

    @Nullable
    public VxBody create(class_2960 typeId, VxPhysicsWorld world, UUID id) {
        VxObjectType<?> type = this.registeredTypes.get(typeId);
        if (type == null) {
            VxMainClass.LOGGER.error("No VxObjectType registered for ID: {}", (Object)typeId);
            return null;
        }
        try {
            return type.create(world, id);
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Failed to create physics object of type {}", (Object)typeId, (Object)e);
            return null;
        }
    }

    @Nullable
    public VxObjectType<?> getRegistrationData(class_2960 typeId) {
        return this.registeredTypes.get(typeId);
    }

    public Map<class_2960, VxObjectType<?>> getRegisteredTypes() {
        return Map.copyOf(this.registeredTypes);
    }

    @Environment(value=EnvType.CLIENT)
    public void registerClientFactory(class_2960 typeId, ClientFactory factory) {
        this.clientFactories.put(typeId, factory);
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public VxClientBody createClientBody(class_2960 typeId, UUID id, VxClientObjectManager manager, int dataStoreIndex, EBodyType objectType) {
        ClientFactory factory = this.clientFactories.get(typeId);
        if (factory != null) {
            try {
                return factory.create(id, manager, dataStoreIndex, objectType);
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Failed to create client body of type {}", (Object)typeId, (Object)e);
            }
        } else {
            VxMainClass.LOGGER.error("No client factory registered for VxObjectType ID: {}", (Object)typeId);
        }
        return null;
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ClientFactory {
        public VxClientBody create(UUID var1, VxClientObjectManager var2, int var3, EBodyType var4);
    }
}

