/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.sync;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import net.xmx.velthoric.physics.object.sync.VxDataSerializer;

public class VxDataAccessor<T> {
    private static final Object2IntMap<Class<?>> ID_POOL = new Object2IntOpenHashMap();
    private static final int MAX_ID_VALUE = 254;
    private final int id;
    private final VxDataSerializer<T> serializer;

    private VxDataAccessor(int id, VxDataSerializer<T> serializer) {
        this.id = id;
        this.serializer = serializer;
    }

    public static <T> VxDataAccessor<T> create(Class<?> bodyClass, VxDataSerializer<T> serializer) {
        int nextId;
        if (ID_POOL.containsKey(bodyClass)) {
            nextId = ID_POOL.getInt(bodyClass) + 1;
        } else {
            int baseId = 0;
            Class<?> currentClass = bodyClass;
            while (currentClass.getSuperclass() != null) {
                if (!ID_POOL.containsKey(currentClass = currentClass.getSuperclass())) continue;
                baseId = ID_POOL.getInt(currentClass) + 1;
                break;
            }
            nextId = baseId;
        }
        if (nextId > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + nextId + "! (Max is 254)");
        }
        ID_POOL.put(bodyClass, nextId);
        return new VxDataAccessor<T>(nextId, serializer);
    }

    public int getId() {
        return this.id;
    }

    public VxDataSerializer<T> getSerializer() {
        return this.serializer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VxDataAccessor that = (VxDataAccessor)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

