/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.type;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyLockRead;
import com.github.stephengold.joltjni.BodyLockWrite;
import com.github.stephengold.joltjni.readonly.ConstBody;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.minecraft.class_3218;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.object.VxObjectType;
import net.xmx.velthoric.physics.object.manager.VxRemovalReason;
import net.xmx.velthoric.physics.object.sync.VxDataAccessor;
import net.xmx.velthoric.physics.object.sync.VxSynchronizedData;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public abstract class VxBody {
    protected final UUID physicsId;
    protected final VxObjectType<? extends VxBody> type;
    protected final VxPhysicsWorld world;
    protected final VxSynchronizedData synchronizedData;
    protected int bodyId = 0;
    protected int dataStoreIndex = -1;

    protected VxBody(VxObjectType<? extends VxBody> type, VxPhysicsWorld world, UUID id) {
        this.type = type;
        this.world = world;
        this.physicsId = id;
        this.synchronizedData = new VxSynchronizedData(EnvType.SERVER);
        this.defineSyncData();
    }

    public void onBodyAdded(VxPhysicsWorld world) {
    }

    public void onBodyRemoved(VxPhysicsWorld world, VxRemovalReason reason) {
    }

    public void physicsTick(VxPhysicsWorld world) {
    }

    public void gameTick(class_3218 level) {
    }

    protected abstract void defineSyncData();

    public <T> T getSyncData(VxDataAccessor<T> accessor) {
        return this.synchronizedData.get(accessor);
    }

    public <T> void setSyncData(VxDataAccessor<T> accessor, T value) {
        this.synchronizedData.set(accessor, value);
        if (this.synchronizedData.isDirty()) {
            this.world.getObjectManager().markCustomDataDirty(this);
        }
    }

    public void writeInitialSyncData(VxByteBuf buf) {
        List<VxSynchronizedData.Entry<?>> allEntries = this.synchronizedData.getAllEntries();
        VxSynchronizedData.writeEntries(buf, allEntries);
    }

    public boolean writeDirtySyncData(VxByteBuf buf) {
        List<VxSynchronizedData.Entry<?>> dirtyEntries = this.synchronizedData.getDirtyEntries();
        if (dirtyEntries == null) {
            return false;
        }
        VxSynchronizedData.writeEntries(buf, dirtyEntries);
        this.synchronizedData.clearDirty();
        return true;
    }

    public void writePersistenceData(VxByteBuf buf) {
    }

    public void readPersistenceData(VxByteBuf buf) {
    }

    public void getTransform(VxTransform outTransform) {
        if (this.dataStoreIndex != -1) {
            this.world.getObjectManager().getTransform(this.dataStoreIndex, outTransform);
        }
    }

    public VxTransform getTransform() {
        if (this.dataStoreIndex != -1) {
            VxTransform transform = new VxTransform();
            this.world.getObjectManager().getTransform(this.dataStoreIndex, transform);
            return transform;
        }
        return new VxTransform();
    }

    @Nullable
    public Body getBody() {
        if (this.bodyId == 0) {
            return null;
        }
        VxBody found = this.world.getObjectManager().getByBodyId(this.bodyId);
        if (found == this) {
            try (BodyLockWrite lock = new BodyLockWrite(this.world.getBodyLockInterface(), this.bodyId);){
                if (lock.succeededAndIsInBroadPhase()) {
                    Body body = lock.getBody();
                    return body;
                }
            }
        }
        return null;
    }

    @Nullable
    public ConstBody getConstBody() {
        if (this.bodyId == 0) {
            return null;
        }
        VxBody found = this.world.getObjectManager().getByBodyId(this.bodyId);
        if (found == this) {
            try (BodyLockRead lock = new BodyLockRead(this.world.getBodyLockInterface(), this.bodyId);){
                if (lock.succeededAndIsInBroadPhase()) {
                    ConstBody constBody = lock.getBody();
                    return constBody;
                }
            }
        }
        return null;
    }

    public UUID getPhysicsId() {
        return this.physicsId;
    }

    public VxObjectType<? extends VxBody> getType() {
        return this.type;
    }

    public VxPhysicsWorld getWorld() {
        return this.world;
    }

    public int getBodyId() {
        return this.bodyId;
    }

    public void setBodyId(int bodyId) {
        this.bodyId = bodyId;
    }

    public int getDataStoreIndex() {
        return this.dataStoreIndex;
    }

    public void setDataStoreIndex(int dataStoreIndex) {
        this.dataStoreIndex = dataStoreIndex;
    }

    public VxSynchronizedData getSynchronizedData() {
        return this.synchronizedData;
    }
}

