/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.util;

import com.github.stephengold.joltjni.BoxShapeSettings;
import com.github.stephengold.joltjni.MutableCompoundShapeSettings;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.List;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.xmx.velthoric.init.VxMainClass;

public final class VxVoxelShapeUtil {
    private VxVoxelShapeUtil() {
    }

    public static MutableCompoundShapeSettings toMutableCompoundShape(class_265 voxelShape) {
        if (voxelShape == null || voxelShape.method_1110()) {
            return null;
        }
        List aabbs = voxelShape.method_1090();
        if (aabbs.isEmpty()) {
            return null;
        }
        MutableCompoundShapeSettings compoundShape = new MutableCompoundShapeSettings();
        Quat identityRotation = Quat.sIdentity();
        try {
            for (class_238 aabb : aabbs) {
                float hx = (float)(aabb.field_1320 - aabb.field_1323) / 2.0f;
                float hy = (float)(aabb.field_1325 - aabb.field_1322) / 2.0f;
                float hz = (float)(aabb.field_1324 - aabb.field_1321) / 2.0f;
                float cx = (float)(aabb.field_1323 + (double)hx - 0.5);
                float cy = (float)(aabb.field_1322 + (double)hy - 0.5);
                float cz = (float)(aabb.field_1321 + (double)hz - 0.5);
                Vec3 position = new Vec3(cx, cy, cz);
                Vec3 halfExtents = new Vec3(hx, hy, hz);
                try (BoxShapeSettings boxSettings = new BoxShapeSettings(halfExtents, 0.0f);){
                    compoundShape.addShape((Vec3Arg)position, (QuatArg)identityRotation, boxSettings);
                }
            }
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Error converting VoxelShape to Jolt compound shape", (Throwable)e);
            compoundShape.close();
            return null;
        }
        return compoundShape;
    }
}

