/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.persistence;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2540;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.persistence.VxAbstractRegionStorage;

public class VxRegionIndex {
    private final Path indexPath;
    private final ConcurrentHashMap<UUID, VxAbstractRegionStorage.RegionPos> index = new ConcurrentHashMap();
    private final AtomicBoolean dirty = new AtomicBoolean(false);

    public VxRegionIndex(Path storagePath, String indexName) {
        this.indexPath = storagePath.resolve(indexName + ".vxidx");
    }

    public void load() {
        if (!Files.exists(this.indexPath, new LinkOption[0])) {
            return;
        }
        try {
            byte[] fileBytes = Files.readAllBytes(this.indexPath);
            if (fileBytes.length == 0) {
                return;
            }
            class_2540 buffer = new class_2540(Unpooled.wrappedBuffer((byte[])fileBytes));
            while (buffer.isReadable()) {
                UUID id = buffer.method_10790();
                int x = buffer.readInt();
                int z = buffer.readInt();
                this.index.put(id, new VxAbstractRegionStorage.RegionPos(x, z));
            }
        }
        catch (IOException e) {
            VxMainClass.LOGGER.error("Failed to load region index from {}", (Object)this.indexPath, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (!this.dirty.getAndSet(false)) {
            return;
        }
        if (this.index.isEmpty()) {
            try {
                Files.deleteIfExists(this.indexPath);
            }
            catch (IOException e) {
                VxMainClass.LOGGER.error("Failed to delete empty region index file {}", (Object)this.indexPath, (Object)e);
            }
            return;
        }
        ByteBuf masterBuf = Unpooled.buffer();
        try {
            class_2540 friendlyMasterBuf = new class_2540(masterBuf);
            this.index.forEach((id, pos) -> {
                friendlyMasterBuf.method_10797(id);
                friendlyMasterBuf.writeInt(pos.x());
                friendlyMasterBuf.writeInt(pos.z());
            });
            Files.createDirectories(this.indexPath.getParent(), new FileAttribute[0]);
            try (FileChannel channel = FileChannel.open(this.indexPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                channel.write(masterBuf.nioBuffer());
            }
        }
        catch (IOException e) {
            VxMainClass.LOGGER.error("Failed to save region index to {}", (Object)this.indexPath, (Object)e);
        }
        finally {
            if (masterBuf.refCnt() > 0) {
                masterBuf.release();
            }
        }
    }

    public void put(UUID id, VxAbstractRegionStorage.RegionPos pos) {
        VxAbstractRegionStorage.RegionPos oldPos = this.index.put(id, pos);
        if (!pos.equals(oldPos)) {
            this.dirty.set(true);
        }
    }

    public VxAbstractRegionStorage.RegionPos get(UUID id) {
        return this.index.get(id);
    }

    public void remove(UUID id) {
        if (this.index.remove(id) != null) {
            this.dirty.set(true);
        }
    }
}

