/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.riding.manager;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.xmx.velthoric.event.api.VxClientPlayerNetworkEvent;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.riding.seat.VxSeat;

public final class VxClientRidingManager {
    private static final VxClientRidingManager INSTANCE = new VxClientRidingManager();
    private final Map<UUID, List<VxSeat>> objectToSeatsMap = new ConcurrentHashMap<UUID, List<VxSeat>>();

    private VxClientRidingManager() {
    }

    public static VxClientRidingManager getInstance() {
        return INSTANCE;
    }

    public static void registerEvents() {
        VxClientPlayerNetworkEvent.LoggingOut.EVENT.register(event -> INSTANCE.clearAll());
    }

    public void addSeatsFromBuffer(UUID objectId, VxByteBuf buf) {
        int seatCount = buf.method_10816();
        if (seatCount > 0) {
            ObjectArrayList seats = new ObjectArrayList(seatCount);
            for (int i = 0; i < seatCount; ++i) {
                seats.add(new VxSeat(buf));
            }
            this.objectToSeatsMap.put(objectId, (List<VxSeat>)seats);
        }
    }

    public void removeSeatsForObject(UUID objectId) {
        this.objectToSeatsMap.remove(objectId);
    }

    public Collection<VxSeat> getSeats(UUID objectId) {
        return this.objectToSeatsMap.getOrDefault(objectId, Collections.emptyList());
    }

    public void clearAll() {
        this.objectToSeatsMap.clear();
    }
}

