/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.riding.manager;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_3222;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.init.registry.EntityRegistry;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.riding.VxRideable;
import net.xmx.velthoric.physics.riding.VxRidingProxyEntity;
import net.xmx.velthoric.physics.riding.input.VxRideInput;
import net.xmx.velthoric.physics.riding.seat.VxSeat;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VxRidingManager {
    private final VxPhysicsWorld world;
    private final Object2ObjectMap<UUID, Map<UUID, VxSeat>> objectToSeatsMap = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<UUID, UUID> playerToObjectIdMap = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<UUID, Map<UUID, class_3222>> objectToRidersMap = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<UUID, VxSeat> playerToSeatMap = new Object2ObjectOpenHashMap();

    public VxRidingManager(VxPhysicsWorld world) {
        this.world = world;
    }

    public void addSeat(UUID objectId, VxSeat seat) {
        ((Map)this.objectToSeatsMap.computeIfAbsent((Object)objectId, k -> new ConcurrentHashMap())).put(seat.getId(), seat);
    }

    public void removeSeat(UUID objectId, UUID seatId) {
        Map seats = (Map)this.objectToSeatsMap.get((Object)objectId);
        if (seats != null) {
            seats.remove(seatId);
            if (seats.isEmpty()) {
                this.objectToSeatsMap.remove((Object)objectId);
            }
        }
    }

    public void requestRiding(class_3222 player, UUID objectId, UUID seatId) {
        VxBody body = this.world.getObjectManager().getObject(objectId);
        if (!(body instanceof VxRideable)) {
            VxMainClass.LOGGER.warn("Player {} requested to ride non-rideable object {}", (Object)player.method_5477().getString(), (Object)objectId);
            return;
        }
        VxRideable rideable = (VxRideable)((Object)body);
        Optional<VxSeat> seatOpt = this.getSeat(objectId, seatId);
        if (seatOpt.isEmpty()) {
            VxMainClass.LOGGER.warn("Player {} requested to ride non-existent seat '{}' on object {}", (Object)player.method_5477().getString(), (Object)seatId, (Object)objectId);
            return;
        }
        VxSeat seat = seatOpt.get();
        double reachDistance = player.method_7337() ? 5.0 : 4.5;
        double distanceSq = player.method_33571().method_1028((double)body.getTransform().getTranslation().x(), (double)body.getTransform().getTranslation().y(), (double)body.getTransform().getTranslation().z());
        if (distanceSq > reachDistance * reachDistance) {
            VxMainClass.LOGGER.warn("Player {} is too far to ride object {} (distSq: {}, reach: {})", (Object)player.method_5477().getString(), (Object)objectId, (Object)distanceSq, (Object)reachDistance);
            return;
        }
        this.startRiding(player, rideable, seat);
    }

    public Optional<VxSeat> getSeat(UUID objectId, UUID seatId) {
        Map seats = (Map)this.objectToSeatsMap.get((Object)objectId);
        return seats != null ? Optional.ofNullable((VxSeat)seats.get(seatId)) : Optional.empty();
    }

    public Optional<VxSeat> getSeatForPlayer(class_3222 player) {
        return Optional.ofNullable((VxSeat)this.playerToSeatMap.get((Object)player.method_5667()));
    }

    public Optional<VxRideable> getRideableForPlayer(class_3222 player) {
        UUID objectId = (UUID)this.playerToObjectIdMap.get((Object)player.method_5667());
        if (objectId == null) {
            return Optional.empty();
        }
        VxBody body = this.world.getObjectManager().getObject(objectId);
        if (body instanceof VxRideable) {
            return Optional.of((VxRideable)((Object)body));
        }
        return Optional.empty();
    }

    public Collection<VxSeat> getSeats(UUID objectId) {
        Map seats = (Map)this.objectToSeatsMap.get((Object)objectId);
        return seats != null ? seats.values() : Collections.emptyList();
    }

    public void startRiding(class_3222 player, VxRideable rideable, VxSeat seat) {
        if (player.method_37908().method_8608() || this.isRiding(player) || this.isSeatOccupied(rideable.getPhysicsId(), seat)) {
            return;
        }
        VxRidingProxyEntity proxy = new VxRidingProxyEntity((class_1299)EntityRegistry.RIDING_PROXY.get(), player.method_37908());
        Vector3f rideOffsetJoml = new Vector3f((Vector3fc)seat.getRiderOffset());
        proxy.setFollowInfo(rideable.getPhysicsId(), rideOffsetJoml);
        VxTransform initialTransform = rideable.getTransform();
        RVec3 initialPos = initialTransform.getTranslation();
        Quat initialRot = initialTransform.getRotation();
        Quaternionf initialQuat = new Quaternionf(initialRot.getX(), initialRot.getY(), initialRot.getZ(), initialRot.getW());
        Vector3f worldOffset = new Vector3f((Vector3fc)rideOffsetJoml);
        initialQuat.transform(worldOffset);
        double finalX = initialPos.x() + worldOffset.x();
        double finalY = initialPos.y() + worldOffset.y();
        double finalZ = initialPos.z() + worldOffset.z();
        Vector3f eulerAngles = new Vector3f();
        initialQuat.getEulerAnglesXYZ(eulerAngles);
        proxy.method_5814(finalX, finalY, finalZ);
        proxy.method_36456((float)Math.toDegrees(eulerAngles.y));
        this.world.getLevel().method_8649((class_1297)proxy);
        player.method_5873((class_1297)proxy, true);
        ((Map)this.objectToRidersMap.computeIfAbsent((Object)rideable.getPhysicsId(), k -> Maps.newHashMap())).put(player.method_5667(), player);
        this.playerToObjectIdMap.put((Object)player.method_5667(), (Object)rideable.getPhysicsId());
        this.playerToSeatMap.put((Object)player.method_5667(), (Object)seat);
        rideable.onStartRiding(player, seat);
    }

    public void stopRiding(class_3222 player) {
        class_1297 vehicle;
        if (!this.isRiding(player)) {
            return;
        }
        UUID playerUuid = player.method_5667();
        UUID objectId = (UUID)this.playerToObjectIdMap.remove((Object)playerUuid);
        this.playerToSeatMap.remove((Object)playerUuid);
        if (objectId != null) {
            this.getRideableForPlayer(player).ifPresent(rideable -> rideable.onStopRiding(player));
            Map riders = (Map)this.objectToRidersMap.get((Object)objectId);
            if (riders != null) {
                riders.remove(playerUuid);
                if (riders.isEmpty()) {
                    this.objectToRidersMap.remove((Object)objectId);
                }
            }
        }
        if ((vehicle = player.method_5854()) instanceof VxRidingProxyEntity) {
            player.method_5848();
            vehicle.method_31472();
        }
    }

    public void onGameTick() {
        ArrayList<Object> playersToStopRiding = new ArrayList<Object>();
        HashSet objectIds = Sets.newHashSet((Iterable)this.objectToRidersMap.keySet());
        for (UUID uUID : objectIds) {
            Map riders = (Map)this.objectToRidersMap.get((Object)uUID);
            if (riders == null) continue;
            VxBody physObject = this.world.getObjectManager().getObject(uUID);
            if (physObject == null) {
                playersToStopRiding.addAll(riders.values());
                continue;
            }
            VxTransform trans = physObject.getTransform();
            RVec3 pos = trans.getTranslation();
            Quat rot = trans.getRotation();
            Quaternionf jomlQuat = new Quaternionf(rot.getX(), rot.getY(), rot.getZ(), rot.getW());
            Vector3f eulerAngles = new Vector3f();
            jomlQuat.getEulerAnglesXYZ(eulerAngles);
            float yawDegrees = (float)Math.toDegrees(eulerAngles.y);
            for (class_3222 rider : Sets.newHashSet(riders.values())) {
                if (rider.method_31481() || !rider.method_5765() || !(rider.method_5854() instanceof VxRidingProxyEntity)) {
                    playersToStopRiding.add(rider);
                    continue;
                }
                VxSeat seat = (VxSeat)this.playerToSeatMap.get((Object)rider.method_5667());
                if (seat != null) {
                    class_1297 vehicle = rider.method_5854();
                    Vector3f rideOffset = new Vector3f((Vector3fc)seat.getRiderOffset());
                    jomlQuat.transform(rideOffset);
                    double finalX = pos.x() + rideOffset.x();
                    double finalY = pos.y() + rideOffset.y();
                    double finalZ = pos.z() + rideOffset.z();
                    vehicle.method_5814(finalX, finalY, finalZ);
                    vehicle.method_36456(yawDegrees);
                    continue;
                }
                playersToStopRiding.add(rider);
            }
        }
        for (class_3222 class_32222 : playersToStopRiding) {
            this.stopRiding(class_32222);
        }
    }

    public void handlePlayerInput(class_3222 player, VxRideInput input) {
        if (!this.isRiding(player)) {
            return;
        }
        this.getSeatForPlayer(player).ifPresent(seat -> {
            if (seat.isDriverSeat()) {
                this.getRideableForPlayer(player).ifPresent(rideable -> rideable.handleDriverInput(player, input));
            }
        });
    }

    public void onPlayerDisconnect(class_3222 player) {
        if (this.isRiding(player)) {
            this.stopRiding(player);
        }
    }

    public Map<UUID, Map<UUID, VxSeat>> getAllSeatsByObject() {
        return Collections.unmodifiableMap(this.objectToSeatsMap);
    }

    public boolean isRiding(class_3222 player) {
        return this.playerToObjectIdMap.containsKey((Object)player.method_5667());
    }

    public boolean isSeatOccupied(UUID objectId, VxSeat seat) {
        Map riders = (Map)this.objectToRidersMap.get((Object)objectId);
        if (riders == null || riders.isEmpty()) {
            return false;
        }
        for (UUID riderUuid : riders.keySet()) {
            VxSeat occupiedSeat = (VxSeat)this.playerToSeatMap.get((Object)riderUuid);
            if (occupiedSeat == null || !occupiedSeat.getId().equals(seat.getId())) continue;
            return true;
        }
        return false;
    }
}

