/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.riding.seat;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import java.util.UUID;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.xmx.velthoric.math.VxOBB;
import net.xmx.velthoric.math.VxTransform;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VxSeat {
    private final UUID seatId;
    private final String seatName;
    private final class_238 localAABB;
    private final Vector3f riderOffset;
    private final boolean isDriverSeat;

    public VxSeat(UUID seatId, String seatName, class_238 localAABB, Vector3f riderOffset, boolean isDriverSeat) {
        this.seatId = seatId;
        this.seatName = seatName;
        this.localAABB = localAABB;
        this.riderOffset = riderOffset;
        this.isDriverSeat = isDriverSeat;
    }

    public VxSeat(class_2540 buf) {
        this.seatId = buf.method_10790();
        this.seatName = buf.method_19772();
        double minX = buf.readDouble();
        double minY = buf.readDouble();
        double minZ = buf.readDouble();
        double maxX = buf.readDouble();
        double maxY = buf.readDouble();
        double maxZ = buf.readDouble();
        this.localAABB = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
        this.riderOffset = new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
        this.isDriverSeat = buf.readBoolean();
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.seatId);
        buf.method_10814(this.seatName);
        buf.writeDouble(this.localAABB.field_1323);
        buf.writeDouble(this.localAABB.field_1322);
        buf.writeDouble(this.localAABB.field_1321);
        buf.writeDouble(this.localAABB.field_1320);
        buf.writeDouble(this.localAABB.field_1325);
        buf.writeDouble(this.localAABB.field_1324);
        buf.writeFloat(this.riderOffset.x());
        buf.writeFloat(this.riderOffset.y());
        buf.writeFloat(this.riderOffset.z());
        buf.writeBoolean(this.isDriverSeat);
    }

    public class_238 getGlobalAABB(VxTransform objectTransform) {
        Vector3f[] corners = new Vector3f[]{new Vector3f((float)this.localAABB.field_1323, (float)this.localAABB.field_1322, (float)this.localAABB.field_1321), new Vector3f((float)this.localAABB.field_1320, (float)this.localAABB.field_1322, (float)this.localAABB.field_1321), new Vector3f((float)this.localAABB.field_1320, (float)this.localAABB.field_1325, (float)this.localAABB.field_1321), new Vector3f((float)this.localAABB.field_1323, (float)this.localAABB.field_1325, (float)this.localAABB.field_1321), new Vector3f((float)this.localAABB.field_1323, (float)this.localAABB.field_1322, (float)this.localAABB.field_1324), new Vector3f((float)this.localAABB.field_1320, (float)this.localAABB.field_1322, (float)this.localAABB.field_1324), new Vector3f((float)this.localAABB.field_1320, (float)this.localAABB.field_1325, (float)this.localAABB.field_1324), new Vector3f((float)this.localAABB.field_1323, (float)this.localAABB.field_1325, (float)this.localAABB.field_1324)};
        Quaternionf rotation = new Quaternionf();
        objectTransform.getRotation(rotation);
        Vector3f translation = new Vector3f();
        objectTransform.getTranslation(translation);
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (Vector3f corner : corners) {
            rotation.transform(corner);
            corner.add((Vector3fc)translation);
            minX = Math.min(minX, corner.x);
            minY = Math.min(minY, corner.y);
            minZ = Math.min(minZ, corner.z);
            maxX = Math.max(maxX, corner.x);
            maxY = Math.max(maxY, corner.y);
            maxZ = Math.max(maxZ, corner.z);
        }
        return new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public VxOBB getGlobalOBB(VxTransform objectTransform) {
        class_243 localCenter = this.localAABB.method_1005();
        RVec3 localCenterRVec = new RVec3(localCenter.field_1352, localCenter.field_1351, localCenter.field_1350);
        localCenterRVec.rotateInPlace(objectTransform.getRotation());
        RVec3 worldSeatCenter = Op.plus((RVec3Arg)objectTransform.getTranslation(), (RVec3Arg)localCenterRVec);
        VxTransform seatTransform = new VxTransform(worldSeatCenter, objectTransform.getRotation());
        double xSize = this.localAABB.method_17939();
        double ySize = this.localAABB.method_17940();
        double zSize = this.localAABB.method_17941();
        class_238 centeredAABB = new class_238(-xSize / 2.0, -ySize / 2.0, -zSize / 2.0, xSize / 2.0, ySize / 2.0, zSize / 2.0);
        return new VxOBB(seatTransform, centeredAABB);
    }

    public UUID getId() {
        return this.seatId;
    }

    public String getName() {
        return this.seatName;
    }

    public class_238 getLocalAABB() {
        return this.localAABB;
    }

    public Vector3f getRiderOffset() {
        return this.riderOffset;
    }

    public boolean isDriverSeat() {
        return this.isDriverSeat;
    }
}

