/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.terrain.cache.VxTerrainShapeCache;
import net.xmx.velthoric.physics.terrain.data.VxChunkDataStore;
import net.xmx.velthoric.physics.terrain.generation.VxGreedyMesher;
import net.xmx.velthoric.physics.terrain.generation.VxTerrainShapeGenerator;
import net.xmx.velthoric.physics.terrain.job.VxTerrainJobSystem;
import net.xmx.velthoric.physics.terrain.management.VxTerrainManager;
import net.xmx.velthoric.physics.terrain.management.VxTerrainTracker;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.NotNull;

public class VxTerrainSystem
implements Runnable {
    private final class_3218 level;
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);
    private final Thread workerThread;
    private final VxTerrainJobSystem jobSystem;
    private final VxChunkDataStore chunkDataStore;
    private final VxTerrainShapeCache shapeCache;
    private final VxGreedyMesher greedyMesher;
    private final VxTerrainShapeGenerator shapeGenerator;
    private final VxTerrainManager terrainManager;
    private final VxTerrainTracker terrainTracker;

    public VxTerrainSystem(VxPhysicsWorld physicsWorld, class_3218 level) {
        this.level = level;
        this.jobSystem = new VxTerrainJobSystem();
        this.chunkDataStore = new VxChunkDataStore();
        this.shapeCache = new VxTerrainShapeCache(1024);
        this.greedyMesher = new VxGreedyMesher(this.shapeCache);
        this.shapeGenerator = new VxTerrainShapeGenerator(physicsWorld, level, this.jobSystem, this.chunkDataStore, this.greedyMesher);
        this.terrainManager = new VxTerrainManager(physicsWorld, level, this.chunkDataStore, this.shapeGenerator);
        this.terrainTracker = new VxTerrainTracker(physicsWorld, this.terrainManager, this.chunkDataStore);
        this.workerThread = new Thread((Runnable)this, "Velthoric Terrain Worker - " + level.method_27983().method_29177().method_12832());
        this.workerThread.setDaemon(true);
    }

    public void initialize() {
        if (this.isInitialized.compareAndSet(false, true)) {
            this.workerThread.start();
        }
    }

    public void shutdown() {
        if (this.isInitialized.compareAndSet(true, false)) {
            this.jobSystem.shutdown();
            this.workerThread.interrupt();
            VxMainClass.LOGGER.debug("Shutting down Terrain System for '{}'.", (Object)this.level.method_27983().method_29177());
            try {
                this.workerThread.join(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.terrainManager.cleanupAllBodies();
            this.chunkDataStore.clear();
            this.terrainTracker.clear();
            this.shapeCache.clear();
            VxMainClass.LOGGER.debug("Terrain system for '{}' has been fully shut down.", (Object)this.level.method_27983().method_29177());
        }
    }

    @Override
    public void run() {
        while (this.isInitialized.get() && !Thread.currentThread().isInterrupted()) {
            try {
                this.terrainTracker.update();
                this.terrainManager.processRebuildQueue();
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Error in TerrainSystem worker thread", (Throwable)e);
            }
        }
    }

    public void onBlockUpdate(class_2338 worldPos) {
        if (this.isInitialized.get()) {
            this.terrainManager.onBlockUpdate(worldPos);
        }
    }

    public void onChunkLoadedFromVanilla(@NotNull class_2818 chunk) {
        if (this.isInitialized.get() && !this.jobSystem.isShutdown()) {
            this.jobSystem.submit(() -> this.terrainManager.onChunkLoadedFromVanilla(chunk));
        }
    }

    public void onChunkUnloaded(@NotNull class_1923 chunkPos) {
        if (this.isInitialized.get() && !this.jobSystem.isShutdown()) {
            this.jobSystem.submit(() -> this.terrainManager.onChunkUnloaded(chunkPos));
        }
    }

    public void onObjectRemoved(UUID id) {
        if (this.isInitialized.get() && !this.jobSystem.isShutdown()) {
            this.jobSystem.submit(() -> this.terrainTracker.removeObjectTracking(id));
        }
    }

    public boolean isTerrainBody(int bodyId) {
        return this.terrainManager.isTerrainBody(bodyId);
    }

    public class_3218 getLevel() {
        return this.level;
    }
}

