/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain.generation;

import com.github.stephengold.joltjni.BoxShapeSettings;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.ShapeResult;
import com.github.stephengold.joltjni.StaticCompoundShapeSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.class_2338;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.terrain.cache.VxTerrainShapeCache;
import net.xmx.velthoric.physics.terrain.chunk.VxChunkSnapshot;

public final class VxGreedyMesher {
    private final VxTerrainShapeCache shapeCache;

    public VxGreedyMesher(VxTerrainShapeCache shapeCache) {
        this.shapeCache = shapeCache;
    }

    public ShapeRefC generateShape(VxChunkSnapshot snapshot) {
        if (snapshot.shapes().isEmpty()) {
            return null;
        }
        int contentHash = this.computeContentHash(snapshot);
        ShapeRefC cached = this.shapeCache.get(contentHash);
        if (cached != null) {
            return cached;
        }
        ShapeRefC generatedShape = this.generateShapeFromVoxels(snapshot);
        if (generatedShape != null) {
            this.shapeCache.put(contentHash, generatedShape.getPtr().toRefC());
        }
        return generatedShape;
    }

    private ShapeRefC generateShapeFromVoxels(VxChunkSnapshot snapshot) {
        boolean[][][] voxels = new boolean[16][16][16];
        for (VxChunkSnapshot.ShapeInfo info : snapshot.shapes()) {
            class_2338 local = info.localPos();
            voxels[local.method_10263()][local.method_10264()][local.method_10260()] = true;
        }
        boolean[][][] visited = new boolean[16][16][16];
        StaticCompoundShapeSettings settings = new StaticCompoundShapeSettings();
        int boxCount = 0;
        for (int y = 0; y < 16; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    if (!voxels[x][y][z] || visited[x][y][z]) continue;
                    int width = 1;
                    while (x + width < 16 && !visited[x + width][y][z] && voxels[x + width][y][z]) {
                        ++width;
                    }
                    int depth = 1;
                    boolean canExpandZ = true;
                    while (z + depth < 16 && canExpandZ) {
                        for (int k = 0; k < width; ++k) {
                            if (!visited[x + k][y][z + depth] && voxels[x + k][y][z + depth]) continue;
                            canExpandZ = false;
                            break;
                        }
                        if (!canExpandZ) continue;
                        ++depth;
                    }
                    int height = 1;
                    boolean canExpandY = true;
                    while (y + height < 16 && canExpandY) {
                        for (int kx = 0; kx < width; ++kx) {
                            for (int kz = 0; kz < depth; ++kz) {
                                if (!visited[x + kx][y + height][z + kz] && voxels[x + kx][y + height][z + kz]) continue;
                                canExpandY = false;
                                break;
                            }
                            if (!canExpandY) break;
                        }
                        if (!canExpandY) continue;
                        ++height;
                    }
                    for (int dy = 0; dy < height; ++dy) {
                        for (int dz = 0; dz < depth; ++dz) {
                            for (int dx = 0; dx < width; ++dx) {
                                visited[x + dx][y + dy][z + dz] = true;
                            }
                        }
                    }
                    float boxHalfWidth = (float)width / 2.0f;
                    float boxHalfHeight = (float)height / 2.0f;
                    float boxHalfDepth = (float)depth / 2.0f;
                    Vec3 halfExtent = new Vec3(boxHalfWidth, boxHalfHeight, boxHalfDepth);
                    Vec3 position = new Vec3((float)x + boxHalfWidth, (float)y + boxHalfHeight, (float)z + boxHalfDepth);
                    BoxShapeSettings boxSettings = new BoxShapeSettings(halfExtent);
                    settings.addShape((Vec3Arg)position, (QuatArg)Quat.sIdentity(), boxSettings);
                    ++boxCount;
                }
            }
        }
        if (boxCount == 0) {
            settings.close();
            return null;
        }
        try {
            ShapeRefC shapeRefC;
            block27: {
                ShapeResult result;
                block25: {
                    ShapeRefC shapeRefC2;
                    block26: {
                        result = settings.create();
                        try {
                            if (!result.isValid()) break block25;
                            shapeRefC2 = result.get();
                            if (result == null) break block26;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return shapeRefC2;
                }
                VxMainClass.LOGGER.error("Failed to create terrain compound shape for {}: {}", (Object)snapshot.pos(), (Object)result.getError());
                shapeRefC = null;
                if (result == null) break block27;
                result.close();
            }
            return shapeRefC;
        }
        finally {
            settings.close();
        }
    }

    private int computeContentHash(VxChunkSnapshot snapshot) {
        ArrayList<Integer> hashes = new ArrayList<Integer>(snapshot.shapes().size());
        for (VxChunkSnapshot.ShapeInfo info : snapshot.shapes()) {
            hashes.add(Objects.hash(info.state().hashCode(), info.localPos().hashCode()));
        }
        Collections.sort(hashes);
        return hashes.hashCode();
    }
}

